ORCA/M Asm65816 2.1.0

0001 E3FD              *******************************************************************************
0002 E3FD              *
0003 E3FD              * File: ATP.INCLUDES
0004 E3FD              *
0005 E3FD              * This file contains the 65816 implementation of ATP for the Apple IIGS.
0006 E3FD              * This file also contains the main AppleTalk dispatcher and core routines.
0007 E3FD              *
0008 E3FD              * Copyright Apple Computer, 1986
0009 E3FD              * Original Author: Greg Seitz
0010 E3FD              *
0011 E3FD              * NOTE: the following lines were changed to get around a problem
0012 E3FD              * in the Mac2Gs assembler:
0013 E3FD              *
0014 E3FD              *  atp.ddpstuff (label opendriver) changed resetcode
0015 E3FD              *
0016 E3FD              *  atp.core (before label vectortab) changed Dispatch
0017 E3FD              *
0018 E3FD              *******************************************************************************
0019 E3FD              *
0020 E3FD              * Modification History
0021 E3FD              *
0022 E3FD              * 8/8/88    TGH     - Started working on RevD ROM
0023 E3FD              *                   - Added 3 vectors Cnxx, CnxxGo, and CnProdos to bank $E1.
0024 E3FD              *                     These will be patched to jump to either 00C1xx or 00C2xx.
0025 E3FD              *
0026 E3FD              * 8/18/88   TGH     - Changed boot code. This will make booting many machines
0027 E3FD              *                     more effecient.
0028 E3FD              *                   - Clear the boot dots position on retry
0029 E3FD              *                   - Changed lookup from 1/4 sec. 30 times to 1 sec. 32 times.
0030 E3FD              *                   - Changed ATP request from 1/2 sec. 20 times to 1 sec.
0031 E3FD              *                     64 times.
0032 E3FD              *
0033 E3FD              * 8/23/88   TGH     - Took out CnProdos vector.  Didn't need it.
0034 E3FD              *
0035 E3FD              * 10/12/88  TGH     - Changed AppleTalk slot search method.
0036 E3FD              *
0037 E3FD              * 11/23/88  TGH     - AppleTalk slot settings are now determined by looking
0038 E3FD              *                     at locations 1C0, 1C1, and 1C2 in bank E1.
0039 E3FD              *
0040 E3FD              * 1/19/88   TGH     - Added NBPKill to command table.
0041 E3FD              *                   - Added CancelTimer call.
0042 E3FD              *
0043 E3FD              * 1/31/88   TGH     - Changed the ReadTimeHex call to a ReadTime call.
0044 E3FD              *
0045 E3FD              * 3/27/88   TGH     - Added OnExitVector
0046 E3FD              *
0047 E3FD              *******************************************************************************
0048 E3FD
0049 E3FD                       MACHINE M65816 
0050 E3FD
0051 E3FD                       IMPORT Dispatch 
0052 E3FD                       IMPORT attachprot 
0053 E3FD                       IMPORT ddpcheckskt 
0054 E3FD                       IMPORT ddpinit 
0055 E3FD                       IMPORT ddpwrite 
0056 E3FD                       IMPORT forbid 
0057 E3FD                       IMPORT getglobal 
0058 E3FD                       IMPORT getinfo 
0059 E3FD              ;        IMPORT invalidseq              ;We don't need this
0060 E3FD                       IMPORT lapresetinit 
0061 E3FD                       IMPORT lapinit 
0062 E3FD                       IMPORT lapread 
0063 E3FD                       IMPORT lapwrite 
0064 E3FD                       IMPORT nbpconfirm 
0065 E3FD                       IMPORT nbplookup 
0066 E3FD                       IMPORT nbpregname 
0067 E3FD                       IMPORT nbpremove 
0068 E3FD                       IMPORT nbpkill 
0069 E3FD                       IMPORT openskt 
0070 E3FD                       IMPORT permit 
0071 E3FD                       IMPORT removeprot 
0072 E3FD                       IMPORT stackrestore 
0073 E3FD                       IMPORT stacksave 
0074 E3FD                       import longforbid,longpermit,closeskt 
0075 E3FD
0076 E3FD                       ENTRY opendriver,\             	;Command vectors
0077 E3FD                             installqtr,\ 
0078 E3FD                             removeqtr,\ 
0079 E3FD                             bootcode,\ 
0080 E3FD                             atpsendrequest,\ 
0081 E3FD                             cancelreq,\ 
0082 E3FD                             openatpsocket,\ 
0083 E3FD                             closeatpsocket,\ 
0084 E3FD                             getrequest,\ 
0085 E3FD                             sendresponse,\ 
0086 E3FD                             relrspcb 
0087 E3FD                              
0088 E3FD              ;        entry opendriver,installqtr,removeqtr,bootcode
0089 E3FD              ;        entry atpsendrequest,cancelreq,openatpsocket,closeatpsocket
0090 E3FD              ;        entry getrequest,sendresponse,relrspcb
0091 E3FD
0092 E3FD                       entry gocomp,bootstart,bootend,iend
0093 E3FD                       entry atplisten,ddpopenskt,sndrqpkt,waitdone,retasynflag
0094 E3FD                       entry readatpheader,rsptable,onebitmask,readrbds,lowbitmask
0095 E3FD                       entry killrequest,watppkt
0096 E3FD                       entry canceltable,closeddpskt,attachtable
0097 E3FD                       entry lowbitmask,reltable,grqtable
0098 E3FD                       entry rspcbtable,iparmstart,entityblk
0099 E3FD                       entry openparms,initparms
0100 E3FD
0101 E3FD                       ENTRY hardreset                ;cold boot entry point
0102 E3FD                       ENTRY softhandler              ;soft reset entry
0103 E3FD
0104 E3FD              ;------------------------------------------------------------------------------
0105 E3FD              ;
0106 E3FD              ; Equates from procedure constants
0107 E3FD              ;
0108 E3FD              ;------------------------------------------------------------------------------
0109 E3FD
0110 E3FD              small    equ   1                        ;remove addresponse
0111 E3FD              code     equ   $000800                  ;boot code comes in here
0112 E3FD              sline    equ   $000480                  ;print on this line
0113 E3FD              romread  equ   $c081
0114 E3FD              lcbank2  equ   $c083
0115 E3FD              statereg equ   $c068
0116 E3FD              cyareg   equ   $c036
0117 E3FD              fixstatereg equ   $6024                 ;Now in LAP......
0118 E3FD              emulstack equ   $010100
0119 E3FD              databank equ   $e1e1e1
0120 E3FD              incbusyflag equ   $e10064               ;scheduler routines
0121 E3FD              decbusyflag equ   $e10068
0122 E3FD
0123 E3FD              atport   equ   $E101C0
0124 E3FD              atslot   equ   $E101C1
0125 E3FD              pmslot   equ   $E101C2
0126 E3FD
0127 E3FD              nbit     equ   $80
0128 E3FD              vbit     equ   $40
0129 E3FD              mbit     equ   $20
0130 E3FD              xbit     equ   $10
0131 E3FD              ibit     equ   $04
0132 E3FD              zbit     equ   $02
0133 E3FD              cbit     equ   $01
0134 E3FD
0135 E3FD              rspval   equ   120                      ;30 seconds for rspcb timer
0136 E3FD
0137 E3FD              atpxobit equ   $20
0138 E3FD              atpeombit equ   $10
0139 E3FD              atpstsbit equ   $08
0140 E3FD
0141 E3FD              ;------------------------------------------------------------------------------
0142 E3FD              ;
0143 E3FD              ; Equates from procedure intface
0144 E3FD              ;
0145 E3FD              ;------------------------------------------------------------------------------
0146 E3FD
0147 E3FD              Extended equ   $e11000                  ;RAM vectors.  Extended interface entry.
0148 E3FD              Basic    equ   Extended+4               ;Basic entry.
0149 E3FD              Pascal   equ   Basic+4                  ;Pascal entry.
0150 E3FD              RamGoComp equ   Pascal+4                ;users gocomp entry for completions
0151 E3FD              SoftReset equ   RamGoComp+4             ;Soft reset chain.
0152 E3FD              RamDispatch equ   SoftReset+4           ;Command dispatcher.
0153 E3FD              RamForbid equ   RamDispatch+4           ;RAM vector to long entry of forbid.
0154 E3FD              RamPermit equ   RamForbid+4             ;For Permit.
0155 E3FD              ProEntry equ   RamPermit+4              ;Original ProDOS entry point.
0156 E3FD              Prodos   equ   ProEntry+2               ;Prodos entry.
0157 E3FD              SerStatus equ   Prodos+4                ;Serial interface status hook
0158 E3FD              SerWrite equ   SerStatus+4              ;" " write hook.
0159 E3FD              SerRead  equ   SerWrite+4               ;For Read.
0160 E3FD              SerBackgnd equ   SerRead+4              ;For background printing.
0161 E3FD              PDispatch equ   SerBackgnd+4            ;For dispatching packets.
0162 E3FD              lapzplen equ   $10
0163 E3FD              e1ddpend equ   $d600                    ;really $e1d600 (gets around dumb link)
0164 E3FD              ddpzplen equ   14
0165 E3FD
0166 E3FD              ;------------------------------------------------------------------------------
0167 E3FD              ;
0168 E3FD              ; Equates from procedure C7Defs
0169 E3FD              ;
0170 E3FD              ;------------------------------------------------------------------------------
0171 E3FD
0172 E3FD              ;C7xx	equ	$C7A0	;emulation mode entry
0173 E3FD              ;C7xxGo	equ	$C7A1	;native mode entry
0174 E3FD              ;C7xxRet	equ	$C7A8	;return point for routines
0175 E3FD              ;C7Error	equ	$C7AB	;error point for pascal not installed
0176 E3FD              ;C7Prodos	equ	$C7AE	;bank 0 entry for prodos
0177 E3FD
0178 E3FD              OfstCnxx equ   $A0                      ;emulation mode entry
0179 E3FD              OfstCnxxGo equ   $A1                    ;native mode entry
0180 E3FD              OfstCnxxRet equ   $A8                   ;return point for routines
0181 E3FD              OfstCnError equ   $AB                   ;error point for pascal not installed
0182 E3FD              OfstCnProdos equ   $AE                  ;bank 0 entry for prodos
0183 E3FD
0184 E3FD              Cnxx     equ   $E11042                  ;emulation mode entry
0185 E3FD              CnxxGo   equ   $E11046                  ;native mode entry
0186 E3FD              OnExitVector equ   $E1104A              ;Exit vector for QTRIRQ
0187 E3FD
0188 E3FD              ;------------------------------------------------------------------------------
0189 E3FD              ;
0190 E3FD              ; Equates from procedure errors
0191 E3FD              ;
0192 E3FD              ;------------------------------------------------------------------------------
0193 E3FD
0194 E3FD              maxatpsize equ   $578
0195 E3FD              lapendbuf equ   $0202
0196 E3FD              lapextra equ   $0209
0197 E3FD              largeddp equ   $0305                    ;only ddp err we care about
0198 E3FD              noatperr equ   $0000
0199 E3FD              largeatp equ   $0501
0200 E3FD              atpbadskt equ   $0502
0201 E3FD              noatpcb  equ   $0503
0202 E3FD              noatprel equ   $0505
0203 E3FD              addnosnd equ   $0506
0204 E3FD              reqabort equ   $0507
0205 E3FD              requestfail equ   $0508
0206 E3FD              sktclsd  equ   $0509
0207 E3FD              toomuchrsp equ   $050b
0208 E3FD              noddpskt equ   $050c
0209 E3FD              rsprel   equ   $050d
0210 E3FD              atpbusy  equ   $05ff
0211 E3FD              noqtrerr equ   $0000
0212 E3FD              noentry  equ   $0101                    ;dispatcher item not found
0213 E3FD              norspcbmem equ   $0102                  ;can't allocate rspcb
0214 E3FD              qtrnotfound equ   $0103
0215 E3FD              noatalkerr equ   $0105
0216 E3FD              qtrcanceled equ   $0106
0217 E3FD              qtrbusy  equ   $01ff
0218 E3FD
0219 E3FD              ;------------------------------------------------------------------------------
0220 E3FD              ;
0221 E3FD              ; Equates from procedure qsecint
0222 E3FD              ;
0223 E3FD              ;------------------------------------------------------------------------------
0224 E3FD
0225 E3FD              insqtr_parmcnt equ   $00
0226 E3FD              insqtr_command equ   insqtr_parmcnt+1
0227 E3FD              insqtr_result equ   insqtr_command+1
0228 E3FD              insqtr_iocomp equ   insqtr_result+2
0229 E3FD              insqtr_ticks equ   insqtr_iocomp+4
0230 E3FD              insqtr_count equ   insqtr_ticks+2
0231 E3FD              insqtr_link equ   insqtr_count+2
0232 E3FD              rmvqtr_parmcnt equ   $00
0233 E3FD              rmvqtr_command equ   rmvqtr_parmcnt+1
0234 E3FD              rmvqtr_result equ   rmvqtr_command+1
0235 E3FD              rmvqtr_rsvd equ   rmvqtr_result+13      ;13 reserved bytes
0236 E3FD
0237 E3FD              ;------------------------------------------------------------------------------
0238 E3FD              ;
0239 E3FD              ; Equates from procedure sendrqint
0240 E3FD              ;
0241 E3FD              ;
0242 E3FD              ; SendATPReq
0243 E3FD              ;
0244 E3FD              ;                      !!! NOTE !!!
0245 E3FD              ;
0246 E3FD              ; The order of the following 8 paramaters must not change
0247 E3FD              ; since some internal assumptions are made about the order
0248 E3FD              ; of the data in order to save execution time and code space.
0249 E3FD              ;
0250 E3FD              ;------------------------------------------------------------------------------
0251 E3FD
0252 E3FD
0253 E3FD              atprq_parmcnt equ   $00
0254 E3FD              atprq_command equ   atprq_parmcnt+1
0255 E3FD              atprq_result equ   atprq_command+1
0256 E3FD              atprq_iocomp equ   atprq_result+2
0257 E3FD              atprq_dymskt equ   atprq_iocomp+4
0258 E3FD              atprq_dnet equ   atprq_dymskt+1
0259 E3FD              atprq_dnode equ   atprq_dnet+2
0260 E3FD              atprq_dskt equ   atprq_dnode+1
0261 E3FD              atprq_tid equ   atprq_dskt+1
0262 E3FD              atprq_bufsize equ   atprq_tid+2
0263 E3FD              atprq_bufptr equ   atprq_bufsize+2
0264 E3FD              atprq_user equ   atprq_bufptr+4
0265 E3FD              atprq_rbnum equ   atprq_user+4
0266 E3FD              atprq_rbdsad equ   atprq_rbnum+1
0267 E3FD              atprq_flag equ   atprq_rbdsad+4
0268 E3FD              atprq_interval equ   atprq_flag+1
0269 E3FD              atprq_rtrycnt equ   atprq_interval+1
0270 E3FD              atprq_bitmap equ   atprq_rtrycnt+1
0271 E3FD              atprq_response equ   atprq_bitmap+1
0272 E3FD              atprq_link equ   atprq_response+1
0273 E3FD              atprq_timeleft equ   atprq_link+4
0274 E3FD              atprq_trysleft equ   atprq_timeleft+1
0275 E3FD
0276 E3FD              ;------------------------------------------------------------------------------
0277 E3FD              ;
0278 E3FD              ; Equates from procedure canrqint
0279 E3FD              ;
0280 E3FD              ;------------------------------------------------------------------------------
0281 E3FD
0282 E3FD              creq_parmcnt equ   $00
0283 E3FD              creq_command equ   creq_parmcnt+1
0284 E3FD              creq_result equ   creq_command+1
0285 E3FD              creq_tid equ   creq_result+2
0286 E3FD
0287 E3FD              ;------------------------------------------------------------------------------
0288 E3FD              ;
0289 E3FD              ; Equates from procedure sendrspint
0290 E3FD              ;
0291 E3FD              ;------------------------------------------------------------------------------
0292 E3FD
0293 E3FD              sdrsp_parmcnt equ   $00
0294 E3FD              sdrsp_command equ   sdrsp_parmcnt+1
0295 E3FD              sdrsp_result equ   sdrsp_command+1
0296 E3FD              sdrsp_iocomp equ   sdrsp_result+2
0297 E3FD              sdrsp_sskt equ   sdrsp_iocomp+4
0298 E3FD              sdrsp_dnet equ   sdrsp_sskt+1
0299 E3FD              sdrsp_dnode equ   sdrsp_dnet+2
0300 E3FD              sdrsp_dskt equ   sdrsp_dnode+1
0301 E3FD              sdrsp_tid equ   sdrsp_dskt+1
0302 E3FD              sdrsp_rbnum equ   sdrsp_tid+2           ;number of buffers send on this call
0303 E3FD              sdrsp_tpkts equ   sdrsp_rbnum+1         ;maximum number of packets being sent
0304 E3FD              sdrsp_rbdsad equ   sdrsp_tpkts+1
0305 E3FD              sdrsp_flag equ   sdrsp_rbdsad+4
0306 E3FD              sdrsp_bitmap equ   sdrsp_flag+1
0307 E3FD              sdrsp_addrtn equ   sdrsp_bitmap+1
0308 E3FD              sdrsp_aflag equ   sdrsp_addrtn+4        ;pass free packets back here
0309 E3FD              addrsp_parmcnt equ   $00
0310 E3FD              addrsp_command equ   addrsp_parmcnt+1
0311 E3FD              addrsp_result equ   addrsp_command+1
0312 E3FD              addrsp_sskt equ   addrsp_result+2
0313 E3FD              addrsp_dnet equ   addrsp_sskt+1
0314 E3FD              addrsp_dnode equ   addrsp_dnet+2
0315 E3FD              addrsp_dskt equ   addrsp_dnode+1
0316 E3FD              addrsp_tid equ   addrsp_dskt+1
0317 E3FD              addrsp_bsize equ   addrsp_tid+2
0318 E3FD              addrsp_bptr equ   addrsp_bsize+2
0319 E3FD              addrsp_user equ   addrsp_bptr+4
0320 E3FD              addrsp_flag equ   addrsp_user+4         ;only used for eom bit
0321 E3FD              addrsp_seqnum equ   addrsp_flag+1       ;packet number we are adding
0322 E3FD
0323 E3FD              ;------------------------------------------------------------------------------
0324 E3FD              ;
0325 E3FD              ; Equates from procedure getrqint
0326 E3FD              ;
0327 E3FD              ;------------------------------------------------------------------------------
0328 E3FD
0329 E3FD              getrq_parmcnt equ   $00
0330 E3FD              getrq_command equ   getrq_parmcnt+1
0331 E3FD              getrq_result equ   getrq_command+1
0332 E3FD              getrq_iocomp equ   getrq_result+2
0333 E3FD              getrq_ourskt equ   getrq_iocomp+4
0334 E3FD              getrq_snet equ   getrq_ourskt+1
0335 E3FD              getrq_snode equ   getrq_snet+2
0336 E3FD              getrq_sskt equ   getrq_snode+1
0337 E3FD              getrq_tid equ   getrq_sskt+1
0338 E3FD              getrq_bufsize equ   getrq_tid+2         ;size of memory buffer points to    
0339 E3FD              getrq_bufptr equ   getrq_bufsize+2      ;address of buffer to put requests into
0340 E3FD              getrq_user equ   getrq_bufptr+4
0341 E3FD              getrq_actlen equ   getrq_user+4         ;actual length of data read in
0342 E3FD              getrq_flag equ   getrq_actlen+2
0343 E3FD              getrq_bitmap equ   getrq_flag+1
0344 E3FD              getrq_link equ   getrq_bitmap+1
0345 E3FD
0346 E3FD              ;------------------------------------------------------------------------------
0347 E3FD              ;
0348 E3FD              ; Equates from procedure opensktint
0349 E3FD              ;
0350 E3FD              ;------------------------------------------------------------------------------
0351 E3FD
0352 E3FD              opskt_parmcnt equ   $00
0353 E3FD              opskt_command equ   opskt_parmcnt+1
0354 E3FD              opskt_result equ   opskt_command+1
0355 E3FD              opskt_skt equ   opskt_result+2
0356 E3FD              clsskt_parmcnt equ   $00
0357 E3FD              clsskt_command equ   clsskt_parmcnt+1
0358 E3FD              clsskt_result equ   clsskt_command+1
0359 E3FD              clsskt_skt equ   clsskt_result+2
0360 E3FD
0361 E3FD              ;------------------------------------------------------------------------------
0362 E3FD              ;
0363 E3FD              ; Equates from procedure cbint
0364 E3FD              ;
0365 E3FD              ;------------------------------------------------------------------------------
0366 E3FD
0367 E3FD              relcb_parmcnt equ   $00
0368 E3FD              relcb_command equ   relcb_parmcnt+1
0369 E3FD              relcb_result equ   relcb_command+1
0370 E3FD              relcb_ourskt equ   relcb_result+2
0371 E3FD              relcb_snet equ   relcb_ourskt+1
0372 E3FD              relcb_snode equ   relcb_snet+2
0373 E3FD              relcb_sskt equ   relcb_snode+1
0374 E3FD              relcb_tid equ   relcb_sskt+1
0375 E3FD              rspcb_link equ   $00                    ;first item is link to next rspcb
0376 E3FD              rspcb_sndptr equ   rspcb_link+4         ;points to associated sndatprsp
0377 E3FD              rspcb_sskt equ   rspcb_sndptr+4         ;source socket
0378 E3FD              rspcb_dnet equ   rspcb_sskt+1           ;destination net
0379 E3FD              rspcb_dnode equ   rspcb_dnet+2          ;destination node
0380 E3FD              rspcb_dskt equ   rspcb_dnode+1          ;destination socket
0381 E3FD              rspcb_tid equ   rspcb_dskt+1            ;transaction id
0382 E3FD              rspcb_timeout equ   rspcb_tid+2         ;internal release timer
0383 E3FD              rspcbsize equ   rspcb_timeout+1         ;size of rspcb
0384 E3FD              bds_bufsize equ   $00
0385 E3FD              bds_bufptr equ   bds_bufsize+2
0386 E3FD              bds_user equ   bds_bufptr+4
0387 E3FD              bds_actlen equ   bds_user+4             ;actual len returned by atp
0388 E3FD
0389 E3FD              ;------------------------------------------------------------------------------
0390 E3FD              ;
0391 E3FD              ; Equates from procedure zeropage
0392 E3FD              ;
0393 E3FD              ;------------------------------------------------------------------------------
0394 E3FD
0395 E3FD              cmdlist  equ   $80                      ;global ptr to paramaters
0396 E3FD              execaddr equ   cmdlist+4
0397 E3FD              stackzp  equ   execaddr+4               ;for use in gocomp
0398 E3FD              prev     equ   execaddr+4               ;previous node pointer
0399 E3FD              curr     equ   prev+4                   ;current node pointer
0400 E3FD              next     equ   curr+4                   ;pointer to next node
0401 E3FD              R0       equ   next+4                   ;4 byte register
0402 E3FD              R1       equ   R0+4                     ;and another
0403 E3FD              R2       equ   R1+4
0404 E3FD              laphead  equ   R2+4                     ;4 byte pointer to lap header
0405 E3FD              bdsptr   equ   laphead+4                ;holds pointer to bds
0406 E3FD              zplen    equ   bdsptr+4-cmdlist         ;length of zero page
0407 E3FD              atpzplen equ   zplen-8                  ;length minus first two vars
0408 E3FD
0409 E3FD              *           using  intface
0410 E3FD              *           using  initblock
0411 E3FD              * the following will be fixed vectors that may be used by
0412 E3FD              * others, the order of these items is fixed and should not
0413 E3FD              * change after we go to rom.
0414 E3FD
0415 E3FD              * now we have the vars that are internal only, therefore they may
0416 E3FD              * be moved and changed as needed
0417 E3FD
0418 E3FD              * ram locations for relocated rom stuff
0419 E3FD
0420 E3FD
0421 E3FD              * this section needs to be initialized to 0 on reset, or normal init
0422 E3FD
0423 E3FD              ;------------------------------------------------------------------------------
0424 E3FD              ;
0425 E3FD              ; Equates from procedure datablock
0426 E3FD              ;
0427 E3FD              ;------------------------------------------------------------------------------
0428 E3FD
0429 E3FD              initoff  equ   $0c
0430 E3FD              openoff  equ   $05
0431 E3FD              closeoff equ   $05
0432 E3FD              lookoff  equ   $18
0433 E3FD              srqoff   equ   $29
0434 E3FD              dataorg  equ   e1ddpend                 ;start data after ddp's data
0435 E3FD              rcmdaddrs equ   dataorg                 ;ram version of dispatch table
0436 E3FD              rcmdaddrs2 equ   dataorg+$114           ;ram version of dispatch table
0437 E3FD              tickcount equ   rcmdaddrs+1024          ;global tick count
0438 E3FD              lsp      equ   tickcount+4              ;current stack pointer
0439 E3FD              apnode   equ   lsp+2                    ;for append routine
0440 E3FD              atpheader equ   apnode+4                ;atp header goes here
0441 E3FD              lookflag equ   atpheader+10             ;flag for looklist
0442 E3FD              moveflag equ   lookflag+2               ;flag to tell looklist to move
0443 E3FD              parmlist equ   moveflag+2               ;general parm list
0444 E3FD              wdsbase  equ   parmlist+20              ;use part of parm list area
0445 E3FD              decval   equ   wdsbase+20
0446 E3FD              status   equ   decval+2                 ;status returned here
0447 E3FD              ysave    equ   status+2
0448 E3FD              cursor   equ   ysave+2
0449 E3FD              currpart equ   cursor+2
0450 E3FD              tempstate equ   currpart+2
0451 E3FD              tempspeed equ   tempstate+1
0452 E3FD              currstack equ   tempspeed+1             ;special stack for listmngr
0453 E3FD              freechunk equ   currstack+40            ;big block of memory
0454 E3FD              ourstack equ   freechunk+512            ;our psuedo stack
0455 E3FD              lookbuf  equ   ourstack+256             ;used only during booting (xtra for stk)
0456 E3FD              rbootstart equ   lookbuf+100
0457 E3FD              rinitparms equ   rbootstart             ;boot stuff gets put here
0458 E3FD              ropenparms equ   rinitparms+initoff
0459 E3FD              rcloseparms equ   ropenparms+openoff
0460 E3FD              rlookparms equ   rcloseparms+closeoff
0461 E3FD              rsrqparms equ   rlookparms+lookoff
0462 E3FD              rsrqbds  equ   rsrqparms+srqoff
0463 E3FD              rparmstart equ   rsrqbds+14             ;normal init data moves here
0464 E3FD              ratpreadp equ   rparmstart              ;past lookbuf
0465 E3FD              initsec  equ   ratpreadp+13             ;init this section to 0
0466 E3FD              rqhead   equ   initsec                  ;head of atp request list
0467 E3FD              availhead equ   rqhead+4                ;points to list of free memory
0468 E3FD              rspcbhead equ   availhead+4             ;points to rspcb list
0469 E3FD              grqhead  equ   rspcbhead+4              ;holds all getrequests issued
0470 E3FD              qtrhead  equ   grqhead+4                ;head of 1/4 sec tasks
0471 E3FD              gnext    equ   qtrhead+4                ;needed for re-entrant remove
0472 E3FD              atptid   equ   gnext+4
0473 E3FD              currsp   equ   atptid+2                 ;special listmngr sp
0474 E3FD              intrlevel equ   currsp+2                ;interrupt disable flag
0475 E3FD              atalkon  equ   intrlevel+2              ;tells us if appletalk has been inited
0476 E3FD              startcount equ   atalkon+2              ;real time counter initial value
0477 E3FD              intervalticks equ   startcount+2        ;number of ticks in a real time interval
0478 E3FD              savecnt  equ   intervalticks-initsec+2  ;number of bytes to zero out
0479 E3FD              e1atpend equ   intrlevel+2              ;allow 10 bytes for ram readprot
0480 E3FD
0481 E3FD
0482 E3FD              main     PROC 
0483 E3FD
0484 E3FD              ;------------------------------------------------------------------------------
0485 E3FD              ;
0486 E3FD              ; We don't have to execute this code because we're moving into ROM.
0487 E3FD              ;
0488 E3FD              ;	import hardreset,softhandler
0489 E3FD              ;
0490 E3FD              ;	longa	on	;16 bit accum
0491 E3FD              ;	longi	on	;and index registers
0492 E3FD              ;	jsr	hardreset	;long entry point for hardreset
0493 E3FD              ;	rtl
0494 E3FD              ;
0495 E3FD              ;
0496 E3FD              ; The following vectors are called from the main vector table for ROM startup
0497 E3FD              ; and ROM reset.
0498 E3FD              ;
0499 E3FD              ;------------------------------------------------------------------------------
0500 E3FD
0501 E3FD                       EXPORT ATHReset 
0502 E3FD                       EXPORT ATSReset 
0503 E3FD
0504 E3FD 4C 94 E5     ATHReset jmp   hardreset                ;cold boot entry point (in rom this goes first)
0505 E400 4C 92 E6     ATSReset jmp   softhandler              ;soft reset entry
0506 E403
0507 E403                       ENDP 
0508 E403
0509 E403
0510 E403              cmdaddrs PROC                           ;data area for jump table
0511 E403
0512 E403 00 00 00 00           DC L:0                         ;no command 0
0513 E407 07 F0 FD              DC A:opendriver                ;call this to init everything
0514 E40A 20                    DC B:atpzplen                  ;save zero page used, sp is set
0515 E40B 80 F3 FD              DC A:getinfo                   ;$02
0516 E40E 10                    DC B:lapzplen                  ;save zp for lap
0517 E40F B7 F6 FD              DC A:getglobal                 ;$03
0518 E412 10                    DC B:lapzplen                  ;save zp for lap
0519 E413 C3 EE FD              DC A:installqtr                ;$04
0520 E416 20                    DC B:atpzplen                  ;save this much
0521 E417 EA EE FD              DC A:removeqtr                 ;$05
0522 E41A 20                    DC B:atpzplen                  ;save this much
0523 E41B CA F1 FD              DC A:bootcode                  ;$06
0524 E41E 00                    DC B:0                         ;no need to save zp
0525 E41F 4A F3 FD              DC A:lapwrite                  ;$07
0526 E422 10                    DC B:lapzplen                  ;save zp for lap
0527 E423 D6 F5 FD              DC A:lapread                   ;$08
0528 E426 10                    DC B:lapzplen                  ;save zp for lap
0529 E427 F7 F6 FD              DC A:attachprot                ;$09
0530 E42A 10                    DC B:lapzplen                  ;save zp for lap
0531 E42B 81 F7 FD              DC A:removeprot                ;$0a
0532 E42E 10                    DC B:lapzplen                  ;save zp for lap
0533 E42F 9E DA FD              DC A:openskt                   ;$0b
0534 E432 0E                    DC B:ddpzplen                  ;length of zero page wanted saved
0535 E433 06 DB FD              DC A:closeskt                  ;$0c
0536 E436 0E                    DC B:ddpzplen                  ;length of zero page wanted saved
0537 E437 F0 D8 FD              DC A:ddpwrite                  ;$0d
0538 E43A 0E                    DC B:ddpzplen                  ;length of zero page wanted saved
0539 E43B 96 DC FD              DC A:nbpregname                ;$0e
0540 E43E 0E                    DC B:ddpzplen                  ;length of zero page wanted saved
0541 E43F 52 E1 FD              DC A:nbpremove                 ;$0f
0542 E442 0E                    DC B:ddpzplen                  ;length of zero page wanted saved
0543 E443 43 DD FD              DC A:nbplookup                 ;$10
0544 E446 0E                    DC B:ddpzplen                  ;length of zero page wanted saved
0545 E447 48 DD FD              DC A:nbpconfirm                ;$11
0546 E44A 0E                    DC B:ddpzplen                  ;length of zero page wanted saved
0547 E44B 1E E8 FD              DC A:atpsendrequest            ;$12
0548 E44E 20                    DC B:atpzplen                  ;length of zero page wanted saved
0549 E44F EC E9 FD              DC A:cancelreq                 ;$13
0550 E452 20                    DC B:atpzplen                  ;length of zero page wanted saved
0551 E453 E3 EB FD              DC A:openatpsocket             ;$14
0552 E456 20                    DC B:atpzplen                  ;length of zero page wanted saved
0553 E457 05 EC FD              DC A:closeatpsocket            ;$15
0554 E45A 20                    DC B:atpzplen                  ;length of zero page wanted saved
0555 E45B C8 EC FD              DC A:getrequest                ;$16
0556 E45E 20                    DC B:atpzplen                  ;length of zero page wanted saved
0557 E45F 0D EB FD              DC A:sendresponse              ;$17
0558 E462 20                    DC B:atpzplen                  ;length of zero page wanted saved
0559 E463
0560 E463                       IF  small GOTO .noadd
0561 E463 00 00 00              DC A:addresponse               ;$18
0562 E466 00                    DC B:atpzplen
0563 E467                       GOTO .tl1 
0564 E467
0565 E467              .noadd    
0566 E467 90 EC FD 20           DC L:0                         ;pad out addresponse ($18)
0567 E46B              .tl1      
0568 E46B EA EE FD              DC A:relrspcb                  ;$19
0569 E46E 20                    DC B:atpzplen                  ;length of zero page wanted saved
0570 E46F
0571 E46F                       entry cmdtabend
0572 E46F              cmdtabend                               ;used in calculation later
0573 E46F                       ENDP 
0574 E46F
0575 E46F              cmdaddrs2 PROC 
0576 E46F
0577 E46F 1A E3 FD              DC A:removeqtr
0578 E472 0E                    DC B:atpzplen
0579 E473 0B A9 00              DC A:nbpkill
0580 E476 00                    DC B:ddpzplen
0581 E477
0582 E477                       entry cmdtabend2
0583 E477              cmdtabend2  
0584 E477                       ENDP 
0585 E477
0586 E477              *******************************************************************************
0587 E477              *                                                                             *
0588 E477              * ATPENTRY - Main entry point to the AppleTalk command dispatcher             *
0589 E477              *                                                                             *
0590 E477              *                                                                             *
0591 E477              * Entry:                                                                      *
0592 E477              *                                                                             *
0593 E477              *                   X = Pointer to command call block (Low Word)              *
0594 E477              *                   Y = Pointer to command call block (High Word)             *
0595 E477              *                                                                             *
0596 E477              *  Necessary items in the command call block:                                 *
0597 E477              *                                                                             *
0598 E477              *                    ______________________________                           *
0599 E477              *                   |                              |                          *
0600 E477              *                   |         Async Flag           |                          *
0601 E477              *                   |______________________________|                          *
0602 E477              *                   |                              |                          *
0603 E477              *                   |         Command              |                          *
0604 E477              *                   |______________________________|                          *
0605 E477              *                   |                              |                          *
0606 E477              *                   |         Result Code          |                          *
0607 E477              *                   |______________________________|                          *
0608 E477              *                   |                              |                          *
0609 E477              *                   .                              .                          *
0610 E477              *                   |      <Command Specific>      |                          *
0611 E477              *                   .                              .                          *
0612 E477              *                   |                              |                          *
0613 E477              *                                                                             *
0614 E477              *******************************************************************************
0615 E477
0616 E477              atpentry PROC                           ;ATP entry point
0617 E477
0618 E477                       EXPORT adispatch 
0619 E477              adispatch                               ;       
0620 E477                       longa on                       ;16 bit accum
0621 E477                       longi on                       ;and index registers
0622 E477
0623 E477                       phd                            ;save direct page
0624 E477                       lda   #0000                    ;and make sure direct page
0625 E477 5B                    tcd                            ;is zero
0626 E478 8B                    phb                            ;save old data bank
0627 E479 F4 E1 E1              pea   databank/256             ;databank in both bytes        
0628 E47C AB                    plb   
0629 E47D AB                    plb                            ;get new data bank
0630 E47E
0631 E47E                       longa off
0632 E47E E2 20                 sep   #mbit                    ;keep 16 bit x, but use 8 bit a
0633 E480
0634 E480 AD 68 C0              lda   statereg                 ;save previous state
0635 E483 48                    pha   
0636 E484 29 CF                 and   #$cf                     ;bits 4&5 zero force read and write main bank
0637 E486 8D 68 C0              sta   statereg
0638 E489 AD 83 C0              lda   lcbank2
0639 E48C AD 83 C0              lda   lcbank2                  ;make sure correct bank is in for $e1
0640 E48F AD 36 C0              lda   cyareg                   ;get speed register
0641 E492 48                    pha                            ;and save for later
0642 E493 09 80                 ora   #$80                     ;make it fast
0643 E495 8D 36 C0              sta   cyareg
0644 E498
0645 E498                       longa on
0646 E498                       longi on
0647 E498 C2 30                 rep   #mbit+xbit               ;back to full x,a
0648 E49A 5A                    phy   
0649 E49B DA                    phx   
0650 E49C A2 80 00              ldx   #cmdlist
0651 E49F A9 08 00              lda   #8                       ;save zp used by dispatcher
0652 E4A2 20 4B E5              jsr   savezp
0653 E4A5 FA                    plx   
0654 E4A6 7A                    ply                            ;recover parms
0655 E4A7 84 82                 sty   cmdlist+2                ;and save x & y as cmdlist
0656 E4A9 86 80                 stx   cmdlist
0657 E4AB
0658 E4AB A0 01 00              ldy   #atprq_command           ;offset to command field
0659 E4AE B7 80                 lda   [cmdlist],y              ;get command byte in lower 8 bits
0660 E4B0 29 FF 00              and   #$00ff                   ;strip off unnecessary bits
0661 E4B3 0A                    asl   a                        ;*2
0662 E4B4 0A                    asl   a                        ;*4 for offset into table
0663 E4B5 AA                    tax                            ;set up for jsr
0664 E4B6 BD 00 D6              lda   rcmdaddrs,x              ;get low word of address
0665 E4B9 85 84                 sta   execaddr                 ;save it in memory
0666 E4BB BD 02 D6              lda   rcmdaddrs+2,x            ;get high bytes
0667 E4BE AA                    tax                            ;hold in x
0668 E4BF 29 FF 00              and   #$00ff                   ;strip high byte (24 bit addresses)
0669 E4C2 85 86                 sta   execaddr+2               ;and save them
0670 E4C4 05 84                 ora   execaddr                 ;see if routine exists
0671 E4C6 F0 6A                 beq   dispatcherr              ;we can't dispatch this
0672 E4C8 8A                    txa                            ;get back high word
0673 E4C9 EB                    xba                            ;swap in # of zp bytes to save
0674 E4CA 29 FF 00              and   #$00ff                   ;only use low byte
0675 E4CD 48                    pha                            ;and save on stack for restore
0676 E4CE A2 88 00              ldx   #cmdlist+8               ;save from this point
0677 E4D1 20 4B E5              jsr   savezp                   ;save what routine wants
0678 E4D4 18                    clc                            ;call long form of routine
0679 E4D5 D4 82                 pei   cmdlist+2                ;high word of cmdlist
0680 E4D7 D4 80                 pei   cmdlist                  ;and low word
0681 E4D9 8B                    phb                            ;save data bank
0682 E4DA
0683 E4DA 22 64 00 E1           jsl   incbusyflag              ;tell scheduler we are busy
0684 E4DE 20 95 FE              jsr   stacksave                ;save stack space if needed
0685 E4E1 22 40 E5 FD           jsl   goexec                   ;go to routine
0686 E4E5 C2 30                 rep   #mbit+xbit               ;make sure full native
0687 E4E7 20 0D FF              jsr   stackrestore             ;restore stack space
0688 E4EA 22 68 00 E1           jsl   decbusyflag              ;let scheduler call code if needed
0689 E4EE
0690 E4EE              goback                                  ; 
0691 E4EE AB                    plb                            ;and restore bank
0692 E4EF C2 31                 rep   #mbit+xbit+cbit          ;force back to 16 bit x,a
0693 E4F1 68                    pla                            ;get low word of cmdlist
0694 E4F2 85 80                 sta   cmdlist
0695 E4F4 68                    pla                            ;and high word
0696 E4F5 85 82                 sta   cmdlist+2
0697 E4F7 68                    pla                            ;recover # of bytes to restore
0698 E4F8              goback1                                 ; ;entry point for bad cmd
0699 E4F8 69 08 00              adc   #8                       ;add in original amount saved
0700 E4FB AA                    tax                            ;and hold on for later
0701 E4FC E2 31                 sep   #mbit+xbit+cbit          ;back to 8 bit mode, assume err
0702 E4FE                       longa off
0703 E4FE                       longi off
0704 E4FE A0 02                 ldy   #2
0705 E500 A7 80                 lda   [cmdlist]                ;get async flag
0706 E502 30 04                 bmi   seterr                   ;so set flags
0707 E504              synchold                                ; 
0708 E504 B7 80                 lda   [cmdlist],y              ;get result field
0709 E506 30 FC                 bmi   synchold                 ;and loop while busy
0710 E508              seterr                                  ; ;now set the error flags
0711 E508 B7 80                 lda   [cmdlist],y              ;get low byte
0712 E50A F0 02                 beq   noerr
0713 E50C 10 06                 bpl   cok                      ;it's an error c=1
0714 E50E              noerr                                   ; 
0715 E50E 18                    clc                            ;no error <=0
0716 E50F F4 00 00              pea   $0000                    ;no error
0717 E512 80 03                 bra   cok1
0718 E514              cok                                     ; 
0719 E514 F4 88 88              pea   $8888                    ;dummy network error
0720 E517              cok1                                    ; 
0721 E517
0722 E517 C2 30                 rep   #mbit+xbit               ;back to full native
0723 E519                       longa on
0724 E519                       longi on
0725 E519 08                    php                            ;save c,x,a
0726 E51A
0727 E51A 8A                    txa                            ;get length
0728 E51B A0 80 00              ldy   #cmdlist                 ;and base to restore
0729 E51E 20 72 E5              jsr   restorezp                ;and restore it
0730 E521
0731 E521 28                    plp                            ;recover c, (x,a=16 bit mode)
0732 E522
0733 E522 68                    pla                            ;recover error
0734 E523
0735 E523 E2 30                 sep   #mbit+xbit               ;back to 8 bit mode, assume err
0736 E525                       longa off
0737 E525                       longi off
0738 E525 FA                    plx                            ;get cyareg (speed register)
0739 E526 8E 36 C0              stx   cyareg                   ;and restore it
0740 E529 FA                    plx                            ;get back statereg
0741 E52A 8E 68 C0              stx   statereg                 ;restore state
0742 E52D
0743 E52D C2 30                 rep   #mbit+xbit
0744 E52F                       longa on
0745 E52F                       longi on
0746 E52F
0747 E52F AB                    plb                            ;restore old data bank
0748 E530 2B                    pld                            ;restore their direct page
0749 E531 60                    rts   
0750 E532
0751 E532              dispatcherr                             ; 
0752 E532 A0 02 00              ldy   #2
0753 E535 A9 01 01              lda   #noentry                 ;dispatch entry was empty
0754 E538 97 80                 sta   [cmdlist],y
0755 E53A 18                    clc   
0756 E53B A9 00 00              lda   #0000
0757 E53E 80 B8                 bra   goback1                  ;and return
0758 E540
0759 E540              goexec                                  ;so others can see this
0760 E540 DC 84 00              jml   [|execaddr]
0761 E543
0762 E543                       entry ldispatch                ; EXPORT -> ENTRY  **TGH
0763 E543              ldispatch                               ;       
0764 E543 20 73 E4              jsr   atpentry                 ;provide a long entry
0765 E546 6B                    rtl                            ;to the dispatcher
0766 E547
0767 E547
0768 E547              * saves a range of memory
0769 E547              * must be called in 16 bit mode
0770 E547              * x=source address
0771 E547              * a=number of bytes
0772 E547              *
0773 E547              * NOTE: This routine also accounts for zero page being
0774 E547              * moved, and thus must treat zp as relative to the D register
0775 E547              *
0776 E547                       EXPORT savee1 
0777 E547              savee1                                  ;
0778 E547 E2 41                 sep   #vbit+cbit               ;e1 mode
0779 E549 80 01                 bra   saveit
0780 E54B                       EXPORT savezp 
0781 E54B              savezp                                  ;       ;saves zero page usage
0782 E54B B8                    clv   
0783 E54C              saveit                                  ; 
0784 E54C                       longa on
0785 E54C                       longi on
0786 E54C C2 31                 rep   #mbit+xbit+cbit          ;make sure 16 bit
0787 E54E 09 00 00              ora   #0000                    ;see if no bytes to move
0788 E551 F0 1A                 beq   rtnzp                    ;none, so return
0789 E553 8B                    phb                            ;save data bank
0790 E554 48                    pha                            ;save move count
0791 E555 08                    php                            ;save v & c=0 bits
0792 E556 AC 04 DA              ldy   lsp                      ;destination address (current sp)
0793 E559 6D 04 DA              adc   lsp                      ;compute new lsp value
0794 E55C 8D 04 DA              sta   lsp                      ;and save it
0795 E55F 28                    plp                            ;recover v & c=0
0796 E560              dskip1                                  ; 
0797 E560 68                    pla                            ;get count
0798 E561 3A                    dec   a                        ;adjust for mvn
0799 E562 70 05                 bvs   dskip2                   ;skip if E1 mode
0800 E564 54 E1 00              mvn   $00,databank             ;save in databank
0801 E567 AB                    plb                            ;and restore bank
0802 E568 60                    rts   
0803 E569              dskip2                                  ; 
0804 E569 54 E1 E1              mvn   databank,databank        ;save in databank
0805 E56C AB                    plb                            ;and restore data bank
0806 E56D              rtnzp                                   ; 
0807 E56D 60                    rts   
0808 E56E
0809 E56E              * restores a range of memory
0810 E56E              * y=first address to restore
0811 E56E              * a=number of bytes
0812 E56E                       EXPORT restoree1 
0813 E56E              restoree1                               ;
0814 E56E E2 40                 sep   #vbit                    ;E1 mode
0815 E570 80 01                 bra   restoreit
0816 E572                       EXPORT restorezp 
0817 E572              restorezp                               ;
0818 E572 B8                    clv                            ;direct page mode
0819 E573              restoreit                               ; 
0820 E573 C2 31                 rep   #mbit+xbit+cbit          ;16 bits, c = 0
0821 E575 3A                    dec   a                        ;get number to move - 1
0822 E576 30 F5                 bmi   rtnzp                    ;if negative, was 0
0823 E578 8B                    phb                            ;save data bank
0824 E579 48                    pha                            ;save for mvn
0825 E57A 08                    php                            ;save v bit and c = 0
0826 E57B AD 04 DA              lda   lsp                      ;get stack pointer
0827 E57E E3 02                 sbc   $2,s                     ;subtract count c=0 but a=a-1
0828 E580 28                    plp                            ;get back v and c = 0
0829 E581 AA                    tax                            ;use for source
0830 E582              dskip3                                  ; 
0831 E582 68                    pla                            ;recover count
0832 E583 DA                    phx                            ;and save new sp (but don't update yet)
0833 E584 70 05                 bvs   dskip4                   ;do e1 mode
0834 E586 54 00 E1              mvn   databank,$00             ;restore from databank
0835 E589 80 03                 bra   finish
0836 E58B              dskip4                                  ; 
0837 E58B 54 E1 E1              mvn   databank,databank
0838 E58E              finish                                  ; 
0839 E58E 68                    pla                            ;get lsp
0840 E58F AB                    plb                            ;restore databank before store
0841 E590 8D 04 DA              sta   lsp
0842 E593 60                    rts   
0843 E594
0844 E594                       ENDP 
0845 E594
0846 E594              *
0847 E594              * hardreset
0848 E594              * this routine is called only after hard reset
0849 E594              * it should set everything up that needs to be
0850 E594              * initialized
0851 E594              *
0852 E594              hardreset PROC 
0853 E594
0854 E594 08                    php                            ;save status
0855 E595 8B                    phb   
0856 E596 20 65 E6              jsr   setup                    ;set speed and databank
0857 E599
0858 E599 C2 30                 rep   #mbit+xbit
0859 E59B                       longa on
0860 E59B                       longi on
0861 E59B
0862 E59B              ;	lda	atport	;This didn't work because SOFT_RESET
0863 E59B              ;	and	#$00FF	;was still being called without the
0864 E59B              ;	bne	@L1	;AppleTalk variables being set.
0865 E59B              ;	jmp	ATalk_Off
0866 E59B
0867 E59B A9 74 DC     @L1      lda   #ourstack                ;set up the stack
0868 E59E 8D 04 DA              sta   lsp
0869 E5A1 9C 68 DE              stz   atalkon                  ;appletalk is not yet active
0870 E5A4
0871 E5A4 A9 00 00              lda   #0000
0872 E5A7 8D 00 D6              sta   rcmdaddrs                ;clear some memory
0873 E5AA A2 00 D6              ldx   #rcmdaddrs               ;first address
0874 E5AD A0 01 D6              ldy   #rcmdaddrs+1             ;destination
0875 E5B0 A9 FE 03              lda   #1024-2                  ;number of bytes to zero
0876 E5B3 54 E1 E1              mvn   databank,databank        ;and move it
0877 E5B6
0878 E5B6              * now we might want to call ddp & lap to let them do what they want
0879 E5B6
0880 E5B6 A2 03 E4              ldx   #cmdaddrs                ;get rom dispatch table
0881 E5B9 A0 00 D6              ldy   #rcmdaddrs               ;and ram address as destination
0882 E5BC A9 67 00              lda   #(cmdtabend-cmdaddrs)-1  ;length of command table
0883 E5BF 54 E1 FD              mvn   main,databank            ;move from rom to ram
0884 E5C2
0885 E5C2 A2 6B E4              ldx   #cmdaddrs2               ;get rom dispatch table
0886 E5C5 A0 14 D7              ldy   #rcmdaddrs2              ;and ram address as destination
0887 E5C8 A9 07 00              lda   #(cmdtabend2-cmdaddrs2)-1 ;length of command table
0888 E5CB 54 E1 FD              mvn   main,databank            ;move from rom to ram
0889 E5CE
0890 E5CE
0891 E5CE              ;                   !FIX OUR CNXX VECTORS HERE!
0892 E5CE
0893 E5CE AF C1 01 E1           lda   atslot
0894 E5D2 29 FF 00              and   #$00FF
0895 E5D5 09 C0 00              ora   #$00C0
0896 E5D8
0897 E5D8 8F 44 10 E1           sta   Cnxx+2
0898 E5DC 8F 48 10 E1           sta   CnxxGo+2
0899 E5E0 8F 0A 10 E1           sta   Pascal+2
0900 E5E4
0901 E5E4 A9 5C 00              lda   #$005C
0902 E5E7 09 00 A0              ora   #OfstCnxx*256
0903 E5EA 8F 42 10 E1           sta   Cnxx
0904 E5EE A9 5C 00              lda   #$005C
0905 E5F1 09 00 A1              ora   #OfstCnxxGo*256
0906 E5F4 8F 46 10 E1           sta   CnxxGo
0907 E5F8 A9 5C 00              lda   #$005C
0908 E5FB 09 00 AB              ora   #OfstCNError*256
0909 E5FE 8F 08 10 E1           sta   Pascal
0910 E602
0911 E602 A9 6B 00              lda   #$006B                   ;Put an rtl into the ONEXITVECTOR
0912 E605 8F 4A 10 E1           sta   OnExitVector
0913 E609 A9 00 00              lda   #$0000
0914 E60C 8F 4C 10 E1           sta   OnExitVector+2
0915 E610
0916 E610 A2 76 F2              ldx   #bootstart               ;relocate boot parms
0917 E613 A0 D8 DD              ldy   #rbootstart              ;into ram
0918 E616 A9 62 00              lda   #(bootend-bootstart)-1   ;length of boot parms
0919 E619 54 E1 FD              mvn   main,databank            ;from rom to ram
0920 E61C
0921 E61C A2 45 E6              ldx   #vectortab               ;jump vectors
0922 E61F A0 00 10              ldy   #Extended                ;address of first ram vector
0923 E622 A9 1F 00              lda   #vectlen-1               ;number of bytes to move
0924 E625 54 E1 FD              mvn   main,databank            ;from rom to ram
0925 E628
0926 E628              * after we check the code out we must put a jml to dispatch at PDispatch
0927 E628
0928 E628 AF 41 E6 FD           lda   >jdispatch
0929 E62C 8F 36 10 E1           sta   PDispatch
0930 E630 AF 43 E6 FD           lda   >jdispatch+2
0931 E634 8F 38 10 E1           sta   PDispatch+2
0932 E638
0933 E638 20 4B F5              jsr   lapresetinit             ;let lap set up variables before any calls are made
0934 E63B
0935 E63B 20 83 E6     ATalk_Off jsr   cleanup
0936 E63E AB                    plb                            ;restore old bank
0937 E63F 28                    plp                            ;and mode bits
0938 E640 6B                    rtl                            ;and return to boot
0939 E641              ;        rts                            ;We used to RTS ;and return to boot
0940 E641
0941 E641 5C 68 FE FD  jdispatch jml   Dispatch                ;code to call built in dispatch
0942 E645
0943 E645              vectortab                               ;this is the vector table
0944 E645 6B 00 00 00           DC L:$6b                       ;rtl for extended
0945 E649 6B 00 00 00           DC L:$6b                       ;rtl for basic
0946 E64D 6B                    DC B:$6b                       ;jml CnError for pascal
0947 E64E 00 00 00              DC A:0
0948 E651 5C                    DC B:$5c                       ;jml gocomp
0949 E652 8A E9 FD              DC A:gocomp
0950 E655 5C                    DC B:$5c                       ;jml anrtl for soft reset chain
0951 E656 A2 E6 FD              DC A:anrtl
0952 E659 5C                    DC B:$5c                       ;jml ldispatch for dispatcher entry
0953 E65A 43 E5 FD              DC A:ldispatch
0954 E65D 5C                    DC B:$5c                       ;jml longforbid
0955 E65E B0 F9 FD              DC A:longForbid
0956 E661 5C                    DC B:$5c                       ;jml longPermit
0957 E662 B4 F9 FD              DC A:longPermit
0958 E665              vectlen  equ   *-vectortab
0959 E665
0960 E665              setup                                   ;       
0961 E665 E2 30                 sep   #mbit+xbit               ;short mode
0962 E667                       longa off
0963 E667                       longi off
0964 E667
0965 E667 A9 E1                 lda   #databank
0966 E669 48                    pha   
0967 E66A AB                    plb   
0968 E66B AD 68 C0              lda   statereg                 ;get previous state.
0969 E66E 2C 83 C0              bit   lcbank2
0970 E671 2C 83 C0              bit   lcbank2                  ;make sure correct bank is in for $e1
0971 E674 8D 4A DA              sta   tempstate                ;save previous state.
0972 E677 AD 36 C0              lda   cyareg                   ;get speed register
0973 E67A 8D 4B DA              sta   tempspeed                ;and save for later
0974 E67D 09 80                 ora   #$80                     ;make it fast
0975 E67F 8D 36 C0              sta   cyareg
0976 E682 60                    rts   
0977 E683
0978 E683              cleanup                                 ;       
0979 E683 E2 30                 sep   #mbit+xbit
0980 E685                       longa off
0981 E685                       longi off
0982 E685
0983 E685 AD 4B DA              lda   tempspeed
0984 E688 8D 36 C0              sta   cyareg
0985 E68B AD 4A DA              lda   tempstate                ;get state reg
0986 E68E 8D 68 C0              sta   statereg
0987 E691 60                    rts   
0988 E692
0989 E692                       entry softhandler              ; EXPORT -> ENTRY
0990 E692              softhandler                             ;call here to dispatch reset chain
0991 E692 08                    php                            ;save mode bits
0992 E693 8B                    phb                            ;save databank
0993 E694 20 65 E6              jsr   setup
0994 E697 C2 30                 rep   #mbit+xbit
0995 E699                       longa on
0996 E699                       longi on
0997 E699 22 10 10 E1           jsl   softreset                ;call code in reset chain
0998 E69D 20 83 E6              jsr   cleanup
0999 E6A0 AB                    plb                            ;restore old databank
1000 E6A1 28                    plp                            ;and mode bits
1001 E6A2
1002 E6A2 6B           anrtl    rtl   
1003 E6A3
1004 E6A3
1005 E6A3                       ENDP 
1006 E6A3              *
1007 E6A3              * atp.listmngr
1008 E6A3              *
1009 E6A3
1010 E6A3              ****************************************************************
1011 E6A3              *
1012 E6A3              *  listmanager-
1013 E6A3              *
1014 E6A3              *  This is the main linked list handler
1015 E6A3              *  It loops through a given linked list and calls a special
1016 E6A3              *  routine for each node that is found.  That routine can then
1017 E6A3              *  return a control code to listmanager, telling it what to do
1018 E6A3              *  with the node.  The currently available options are:
1019 E6A3              *
1020 E6A3              *  when returning to the list manager if the carry is set then
1021 E6A3              *  we will stop scanning the list, otherwise we will continue
1022 E6A3              *
1023 E6A3              *
1024 E6A3              *  Inputs:  the following are passed on the stack:
1025 E6A3              *
1026 E6A3              *           head address -      16 bits
1027 E6A3              *                               address of pointer to head of linked
1028 E6A3              *                               list.  This points to head-link offset.
1029 E6A3              *           special routine -   16 bits
1030 E6A3              *                               special routine to be called for each
1031 E6A3              *                               node encountered
1032 E6A3              *           return address -    16 bits
1033 E6A3              *                               return address put here by jsr
1034 E6A3              *  Register Inputs:
1035 E6A3              *
1036 E6A3              *           offset to link -    y-reg (16 bits)
1037 E6A3              *                               offset from node address to next link
1038 E6A3              *                               field
1039 E6A3              *
1040 E6A3              *  Outputs: none currently
1041 E6A3              *
1042 E6A3              ****************************************************************
1043 E6A3
1044 E6A3              listmanager PROC                        ;main list loop
1045 E6A3
1046 E6A3              *
1047 E6A3              * set up pointers before loop
1048 E6A3              *
1049 E6A3                       longa on
1050 E6A3                       longi on
1051 E6A3 C2 30                 rep   #mbit+xbit
1052 E6A5
1053 E6A5 A3 05                 lda   $5,s                     ;get low word of head address
1054 E6A7 85 88                 sta   prev                     ;save low word of previous ptr (head)
1055 E6A9 A9 E1 00              lda   #^databank               ;get high word
1056 E6AC 85 8A                 sta   prev+2
1057 E6AE BB                    tyx                            ;hold link offset temporarily
1058 E6AF B7 88                 lda   [prev],y                 ;get low word of first node
1059 E6B1 85 8C                 sta   curr                     ;and save it
1060 E6B3 C8                    iny   
1061 E6B4 C8                    iny   
1062 E6B5 B7 88                 lda   [prev],y                 ;and get high word
1063 E6B7 85 8E                 sta   curr+2
1064 E6B9 9B                    txy                            ;recover link offset
1065 E6BA 8C 44 DA              sty   ysave                    ;and save globally
1066 E6BD              testcurr                                ; ;top of while loop
1067 E6BD A5 8C                 lda   curr                     ;get low word
1068 E6BF 05 8E                 ora   curr+2                   ;check against high word
1069 E6C1 F0 2D                 beq   listdone                 ;we are done if both are zero
1070 E6C3 B7 8C                 lda   [curr],y                 ;get low word of next link
1071 E6C5 85 90                 sta   next                     ;and save it
1072 E6C7 BB                    tyx                            ;save index
1073 E6C8 C8                    iny                            ;and bump up to
1074 E6C9 C8                    iny                            ;high word
1075 E6CA B7 8C                 lda   [curr],y                 ;get it
1076 E6CC 85 92                 sta   next+2                   ;and save
1077 E6CE DA                    phx                            ;save link offset on stack
1078 E6CF 9B                    txy                            ;set up link offset for call
1079 E6D0 F4 D7 E6              pea   comeback                 ;address to return to
1080 E6D3 A3 07                 lda   $7,s                     ;get routine off stack
1081 E6D5 3A                    dec   a                        ;make it so we can rts to
1082 E6D6 48                    pha                            ;fake an indirect jsr
1083 E6D7 60           comeback rts                            ;we actually will return to the
1084 E6D8                                                      ;next instruction after the RTS
1085 E6D8                                                      ;this will call routine pushed on stk
1086 E6D8
1087 E6D8              * this is where we return to from that pea comeback done a few lines earlier
1088 E6D8
1089 E6D8 C2 30                 rep   #mbit+xbit               ;make sure 16 bit x,a
1090 E6DA
1091 E6DA 7A                    ply                            ;finally, restore link offset
1092 E6DB B0 13                 bcs   listdone                 ;we are done since the want to stop
1093 E6DD A5 8C                 lda   curr                     ;otherwise continue to scan list
1094 E6DF 85 88                 sta   prev                     ;prev=curr
1095 E6E1 A5 8E                 lda   curr+2
1096 E6E3 85 8A                 sta   prev+2
1097 E6E5 A5 90                 lda   next                     ;curr=next (move to next node)
1098 E6E7 85 8C                 sta   curr
1099 E6E9 A5 92                 lda   next+2
1100 E6EB 85 8E                 sta   curr+2
1101 E6ED 82 CD FF              brl   testcurr                 ;loop for more
1102 E6F0              listdone                                ; ;clean up and leave
1103 E6F0 A3 01                 lda   $1,s                     ;get return address
1104 E6F2 83 05                 sta   $5,s                     ;move it up to where it belongs
1105 E6F4 3B                    tsc                            ;get stack pointer in accum
1106 E6F5 18                    clc                            ;set up for add
1107 E6F6 69 04 00              adc   #4                       ;scrape garbage of stack
1108 E6F9 1B                    tcs                            ;fix stack pointer
1109 E6FA 60                    rts                            ;and return
1110 E6FB
1111 E6FB
1112 E6FB                       entry dodelete                 ; EXPORT -> ENTRY  **TGH
1113 E6FB              dodelete                                ;delete the current node
1114 E6FB BB                    tyx                            ;save link offset
1115 E6FC A5 90                 lda   next
1116 E6FE 97 88                 sta   [prev],y                 ;cut out current node
1117 E700 C8                    iny                            ;bump to high word
1118 E701 C8                    iny   
1119 E702 A5 92                 lda   next+2
1120 E704 97 88                 sta   [prev],y
1121 E706
1122 E706              exitdelete                              ; ;leave through here
1123 E706              *
1124 E706              * now, since we are allowing the list manager to be recursively
1125 E706              * re-entrant, if we happen to be deleting someone elses curr node
1126 E706              * we must update their curr value on the stack to the real curr item
1127 E706              * we must do this for each item on the stack that matches the node
1128 E706              * being deleted.
1129 E706              *
1130 E706 AC 64 DE              ldy   currsp                   ;get special stack pointer
1131 E709 F0 1E                 beq   stackok                  ;stack is ok now since nothing there
1132 E70B              * now check to see if the node we just deleted was somebodies current 
1133 E70B              * node, and if so, adjust the special stack to let give them our prev
1134 E70B              * node to compensate for the just deleted node
1135 E70B              chkprev                                 ; ;check special stack
1136 E70B A5 8E                 lda   curr+2                   ;check node deleted against
1137 E70D D9 4A DA              cmp   currstack-2,y            ;their prev node
1138 E710 D0 11                 bne   backup                   ;check next item on stack
1139 E712 A5 8C                 lda   curr
1140 E714 D9 48 DA              cmp   currstack-4,y            ;check low word
1141 E717 D0 0A                 bne   backup                   ;not a match
1142 E719 A5 88                 lda   prev                     ;give them a new curr value
1143 E71B 99 48 DA              sta   currstack-4,y            ;since we are deleting theirs
1144 E71E A5 8A                 lda   prev+2
1145 E720 99 4A DA              sta   currstack-2,y
1146 E723              backup                                  ; ;move down stack
1147 E723 88                    dey   
1148 E724 88                    dey   
1149 E725 88                    dey   
1150 E726 88                    dey   
1151 E727 D0 E2                 bne   chkprev                  ;still something on stack
1152 E729              stackok                                 ; 
1153 E729 A5 88                 lda   prev                     ;curr=prev to adjust for
1154 E72B 85 8C                 sta   curr                     ;deleted node
1155 E72D A5 8A                 lda   prev+2
1156 E72F 85 8E                 sta   curr+2
1157 E731 9B                    txy                            ;restore link offset
1158 E732 60                    rts                            ;and return
1159 E733
1160 E733 20 FB E6     ldodelete jsr   dodelete                ;use for long entry to delete
1161 E736 6B                    rtl   
1162 E737
1163 E737
1164 E737                       entry pushcurr                 ; EXPORT -> ENTRY  **TGH
1165 E737              pushcurr                                ;       ;push current node
1166 E737 AE 64 DE              ldx   currsp                   ;get current stack value
1167 E73A E8                    inx   
1168 E73B E8                    inx   
1169 E73C E8                    inx   
1170 E73D E8                    inx   
1171 E73E 8E 64 DE              stx   currsp                   ;update stack before pushing
1172 E741 A5 8C                 lda   curr
1173 E743 9D 48 DA              sta   currstack-4,x
1174 E746 A5 8E                 lda   curr+2
1175 E748 9D 4A DA              sta   currstack-2,x
1176 E74B 60                    rts   
1177 E74C
1178 E74C                       entry pullcurr                 ; EXPORT -> ENTRY  **TGH
1179 E74C              pullcurr                                ;       ;recover current and next values
1180 E74C AE 64 DE              ldx   currsp
1181 E74F BD 4A DA              lda   currstack-2,x            ;get high word of next
1182 E752 85 8E                 sta   curr+2                   ;and save it
1183 E754 BD 48 DA              lda   currstack-4,x            ;and get low word
1184 E757 85 8C                 sta   curr                     ;and save low word
1185 E759 CA                    dex   
1186 E75A CA                    dex   
1187 E75B CA                    dex   
1188 E75C CA                    dex   
1189 E75D              * now that we have recovered curr, lets get the next value from it
1190 E75D B7 8C                 lda   [curr],y                 ;get low word of next node
1191 E75F 85 90                 sta   next                     ;and save it
1192 E761 C8                    iny   
1193 E762 C8                    iny   
1194 E763 B7 8C                 lda   [curr],y                 ;and get high word
1195 E765 85 92                 sta   next+2
1196 E767 88                    dey   
1197 E768 88                    dey                            ;re-adjust y to original value
1198 E769 8E 64 DE              stx   currsp                   ;and save the new stack
1199 E76C 60                    rts   
1200 E76D
1201 E76D
1202 E76D                       ENDP 
1203 E76D              *
1204 E76D              * atp.listrtns
1205 E76D              *
1206 E76D              * this is a group of routines that make use
1207 E76D              * of the list manager to provide extended list
1208 E76D              * functions
1209 E76D              *
1210 E76D
1211 E76D              ****************************************************************
1212 E76D              *
1213 E76D              *  addlist-    
1214 E76D              *
1215 E76D              *  This routine adds a node    that is passed on the stack
1216 E76D              *  to the front of a list whose head address is also passed
1217 E76D              *  on the stack.
1218 E76D              *
1219 E76D              *  Stack Inputs:
1220 E76D              *
1221 E76D              *           head address - 16 bits
1222 E76D              *                                       address of pointer to head
1223 E76D              *                                       of linked list
1224 E76D              *           item address - 32 bits
1225 E76D              *                                       address of item to be appended
1226 E76D              *           return address - 16 bits
1227 E76D              *                                       return address
1228 E76D              *
1229 E76D              *  Register Inputs:
1230 E76D              *
1231 E76D              *           offset to link - y-reg (16 bits)
1232 E76D              *                                       offset from node address to
1233 E76D              *                                       next link field
1234 E76D              *
1235 E76D              *  Outputs:
1236 E76D              *
1237 E76D              *           none currently
1238 E76D              *
1239 E76D              *  Destroys:
1240 E76D              *           nothing
1241 E76D              *
1242 E76D              ****************************************************************
1243 E76D
1244 E76D              addlist  PROC 
1245 E76D
1246 E76D FA                    plx                            ;get return address
1247 E76E 68                    pla                            ;get low word of node to insert
1248 E76F 85 8C                 sta   curr                     ;save locally
1249 E771 68                    pla                            ;get high word
1250 E772 85 8E                 sta   curr+2
1251 E774 68                    pla                            ;get low word of head address
1252 E775 85 88                 sta   prev                     ;save in zp
1253 E777 DA                    phx                            ;put return address back on stack
1254 E778 BB                    tyx                            ;save link offset
1255 E779 B1 88                 lda   (prev),y
1256 E77B 97 8C                 sta   [curr],y                 ;save low word
1257 E77D C8                    iny   
1258 E77E C8                    iny   
1259 E77F B1 88                 lda   (prev),y
1260 E781 97 8C                 sta   [curr],y
1261 E783 A5 8E                 lda   curr+2
1262 E785 91 88                 sta   (prev),y                 ;save new head high word
1263 E787 9B                    txy                            ;get original offset
1264 E788 A5 8C                 lda   curr
1265 E78A 91 88                 sta   (prev),y
1266 E78C AC 64 DE              ldy   currsp                   ;check special stack
1267 E78F F0 1F                 beq   stackok                  ;nothing on it
1268 E791              chkprev                                 ; 
1269 E791 A5 88                 lda   prev                     ;see if we have a match
1270 E793 D9 48 DA              cmp   currstack-4,y            ;check head against their curr
1271 E796 D0 12                 bne   backup
1272 E798 A9 E1 00              lda   #^databank               ;high word of head
1273 E79B D9 4A DA              cmp   currstack-2,y
1274 E79E D0 0A                 bne   backup                   ;keep checking
1275 E7A0 A5 8E                 lda   curr+2                   ;change curr val on stack
1276 E7A2 99 4A DA              sta   currstack-2,y
1277 E7A5 A5 8C                 lda   curr
1278 E7A7 99 48 DA              sta   currstack-4,y
1279 E7AA              backup                                  ; 
1280 E7AA 88                    dey   
1281 E7AB 88                    dey   
1282 E7AC 88                    dey   
1283 E7AD 88                    dey   
1284 E7AE D0 E1                 bne   chkprev
1285 E7B0 60           stackok  rts                            ;and return
1286 E7B1
1287 E7B1
1288 E7B1                       ENDP 
1289 E7B1
1290 E7B1
1291 E7B1              ****************************************************************
1292 E7B1              *
1293 E7B1              *  looklist -
1294 E7B1              *
1295 E7B1              *  This routine looks in a list for a node that
1296 E7B1              *  belongs to the packet that was just received.
1297 E7B1              *  It does this by using a comparison table that
1298 E7B1              *  tells it what items are expected to match.
1299 E7B1              *  The packet that was read must be at a fixed
1300 E7B1              *  location, and must use the long ddp form.
1301 E7B1              *  This is acceptable since our implementation of
1302 E7B1              *  ddp puts all packets into long form before
1303 E7B1              *  passing control to its socket listener.
1304 E7B1              *
1305 E7B1              *  Stack Inputs:
1306 E7B1              *                  head address - 16 bits
1307 E7B1              *                                       address of pointer to
1308 E7B1              *                                       head of list to search
1309 E7B1              *                  compare table - 16 bits
1310 E7B1              *                                       this is the table that
1311 E7B1              *                                       tells what items relative
1312 E7B1              *                                       to the beginning of the
1313 E7B1              *                                       protocol layers need to
1314 E7B1              *                                       be examined.
1315 E7B1              *                                       NOTE: it is assumed that this
1316 E7B1              *                                       table is in the same bank as the
1317 E7B1              *                                       code.
1318 E7B1              *                  return address - 16 bits
1319 E7B1              *
1320 E7B1              *  Register Inputs:
1321 E7B1              *                  y-reg                link offset
1322 E7B1              *
1323 E7B1              *  Status Flags:
1324 E7B1              *                  z=1                  no match found
1325 E7B1              *                  z=0                  match found
1326 E7B1              *
1327 E7B1              *  Memory Outputs:
1328 E7B1              *                  cmdlist              holds value of node found
1329 E7B1              *
1330 E7B1              *  Destroys:
1331 E7B1              *                  R0,R1,R2
1332 E7B1              *
1333 E7B1              ****************************************************************
1334 E7B1              *
1335 E7B1              looklist PROC 
1336 E7B1
1337 E7B1                       longa on
1338 E7B1                       longi on
1339 E7B1 C2 30                 rep   #mbit+xbit
1340 E7B3
1341 E7B3 BB                    tyx                            ;save offset
1342 E7B4 9C 14 DA              stz   lookflag                 ;not found yet
1343 E7B7 9C 16 DA              stz   moveflag                 ;no move wanted
1344 E7BA 68                    pla                            ;get return address
1345 E7BB 85 9C                 sta   R2                       ;only uses 16 bits for return
1346 E7BD 68                    pla                            ;get compare table address
1347 E7BE 38                    sec                            ;for subtract
1348 E7BF E9 08 00              sbc   #sdrsp_sskt              ;back up pointer to table
1349 E7C2 85 94                 sta   R0                       ;and save for spcl routine
1350 E7C4 4B                    phk                            ;push program bank
1351 E7C5 4B                    phk                            ;and again (since 16 bit mode)
1352 E7C6 68                    pla                            ;now recover it and use it for
1353 E7C7 85 96                 sta   R0+2                     ;high word of our code bank
1354 E7C9 F4 DC E7              pea   lookspcl                 ;set up stack for listmanager
1355 E7CC 20 A3 E6              jsr   listmanager              ;and loop through list
1356 E7CF D4 9C                 pei   R2                       ;push return address
1357 E7D1 AD 14 DA              lda   lookflag                 ;set status bit
1358 E7D4 60                    rts                            ;and return
1359 E7D5
1360 E7D5                       entry listmove                 ; EXPORT -> ENTRY  **TGH
1361 E7D5              listmove                                ;alternate entry for moving
1362 E7D5                       longa off
1363 E7D5                       longi off
1364 E7D5 E2 30                 sep   #mbit+xbit               ;go to 8 bit
1365 E7D7 A9 01                 lda   #01                      ;set move flag
1366 E7D9 8D 16 DA              sta   moveflag
1367 E7DC
1368 E7DC              lookspcl                                ; ;special node routine
1369 E7DC              *
1370 E7DC              * R0 contains a pointer to the compare table - sdrsp_sskt
1371 E7DC              * the reason it points to this is that the comparing does
1372 E7DC              * not start until sdrsp_sskt, and therefore the previous
1373 E7DC              * bytes in the command list do not matter
1374 E7DC              *
1375 E7DC E2 70                 sep   #xbit+mbit+vbit          ;8 bit x,a, force v for ddp mode
1376 E7DE
1377 E7DE A0 07                 ldy   #sdrsp_sskt-1            ;this is where we will compare
1378 E7E0              looksp1                                 ; 
1379 E7E0 C8                    iny                            ;move to next item in lists
1380 E7E1 B7 94                 lda   [R0],y                   ;get the compare table item
1381 E7E3 F0 FB                 beq   looksp1                  ;keep going with next item
1382 E7E5 10 08                 bpl   checkvbit                ;it's a real index
1383 E7E7 1A                    inc   a                        ;see if was 255
1384 E7E8 F0 20                 beq   found                    ;we passed all tests
1385 E7EA 3A                    dec   a                        ;back up a
1386 E7EB 29 7F                 and   #$7f                     ;strip high bit
1387 E7ED C2 40                 rep   #vbit                    ;clear vbit for atp mode switch
1388 E7EF              checkvbit                               ; 
1389 E7EF 5A                    phy                            ;save loop index
1390 E7F0 A8                    tay                            ;set up index to packet data
1391 E7F1 B7 A0                 lda   [laphead],y              ;assume from lap and ddp
1392 E7F3 70 03                 bvs   goodguess                ;we were right
1393 E7F5 B9 0A DA              lda   atpheader,y              ;we were wrong (no big deal)
1394 E7F8              goodguess                               ; 
1395 E7F8 7A                    ply                            ;get back loop index
1396 E7F9 AE 16 DA              ldx   moveflag                 ;see if move or compare should be done
1397 E7FC F0 04                 beq   compare                  ;do a compare
1398 E7FE 97 8C                 sta   [curr],y                 ;do a move
1399 E800 80 DE                 bra   looksp1                  ;do next byte
1400 E802              compare                                 ; 
1401 E802 D7 8C                 cmp   [curr],y                 ;see if matches data in list
1402 E804 F0 DA                 beq   looksp1                  ;yes so keep checking
1403 E806 18           nomatch  clc                            ;skip code (this is why we use 8 bits)
1404 E807 C2 30        goback   rep   #mbit+xbit               ;back to 16 x,a
1405 E809 60                    rts                            ;and return
1406 E80A
1407 E80A AE 16 DA     found    ldx   moveflag                 ;see if move or compare
1408 E80D D0 F8                 bne   goback                   ;just return if move
1409 E80F C2 30                 rep   #mbit+xbit               ;back to 16 x,a
1410 E811                       longa on
1411 E811                       longi on
1412 E811 A5 8C                 lda   curr
1413 E813 85 80                 sta   cmdlist                  ;this is where we return the pointer
1414 E815 A5 8E                 lda   curr+2
1415 E817 85 82                 sta   cmdlist+2
1416 E819 EE 14 DA              inc   lookflag                 ;tell main routine that we found it
1417 E81C 38                    sec                            ;set stop bit
1418 E81D 60                    rts                            ;and return
1419 E81E
1420 E81E                       ENDP 
1421 E81E              *
1422 E81E              * atp.sndrequest
1423 E81E              *
1424 E81E              *
1425 E81E
1426 E81E              atpsendrequest PROC 
1427 E81E
1428 E81E 20 B8 F9              jsr   forbid                   ;hold off ints
1429 E821
1430 E821 A0 0F 00              ldy   #atprq_bufsize
1431 E824 B7 80                 lda   [cmdlist],y              ;get size of buffer to send
1432 E826 C9 79 05              cmp   #maxatpsize+1            ;see if too big
1433 E829 90 05                 bcc   bufsizeok                ;its ok
1434 E82B A9 01 05              lda   #largeatp                ;atp data too large
1435 E82E 80 57                 bra   badskt                   ;and report the error
1436 E830              bufsizeok                               ; 
1437 E830 E2 30                 sep   #mbit+xbit
1438 E832                       longa off
1439 E832                       longi off
1440 E832
1441 E832 A0 19                 ldy   #atprq_rbnum
1442 E834 B7 80                 lda   [cmdlist],y              ;see how many response buffers
1443 E836 C9 09                 cmp   #9                       ;see if too many
1444 E838 90 07                 bcc   bufsok                   ;number of bufs is ok
1445 E83A
1446 E83A C2 30                 rep   #mbit+xbit               ;back to 16 bit a,x
1447 E83C                       longa on
1448 E83C                       longi on
1449 E83C A9 0B 05              lda   #toomuchrsp              ;too many rsp buffers
1450 E83F 80 46                 bra   badskt                   ;and report the error
1451 E841
1452 E841              bufsok                                  ; 
1453 E841 C2 30                 rep   #mbit+xbit
1454 E843                       longa on
1455 E843                       longi on
1456 E843
1457 E843 A2 8A E8              ldx   #<atplisten              ;get low word
1458 E846 A0 FD 00              ldy   #^atplisten              ;and high word
1459 E849 A9 00 00              lda   #0                       ;ask for dynamic socket
1460 E84C 20 C5 EF              jsr   ddpopenskt               ;open socket listener
1461 E84F D0 36                 bne   badskt                   ;some kind of ddp error 
1462 E851
1463 E851 E2 30                 sep   #mbit+xbit               ;8 bit x,a
1464 E853                       longa off
1465 E853                       longi off
1466 E853
1467 E853 8A                    txa                            ;get socket from x
1468 E854 A0 08                 ldy   #atprq_dymskt            ;get offset to socket
1469 E856 97 80                 sta   [cmdlist],y              ;put socket in list
1470 E858 A0 20                 ldy   #atprq_rtrycnt           ;get offset to retry count
1471 E85A B7 80                 lda   [cmdlist],y              ;get it
1472 E85C A0 28                 ldy   #atprq_trysleft          ;set up trysleft first time
1473 E85E 97 80                 sta   [cmdlist],y
1474 E860 A9 00                 lda   #00                      ;zero out number of responses
1475 E862 A0 22                 ldy   #atprq_response          ;received
1476 E864 97 80                 sta   [cmdlist],y
1477 E866
1478 E866 C2 30                 rep   #mbit+xbit               ;back to 16 bit a,x
1479 E868                       longa on
1480 E868                       longi on
1481 E868
1482 E868 F4 27 DE              pea   rqhead-atprq_link        ;low word of head-offset
1483 E86B D4 82                 pei   cmdlist+2                ;high word of cmdlist
1484 E86D D4 80                 pei   cmdlist
1485 E86F A0 23 00              ldy   #atprq_link              ;offset to link
1486 E872 20 6D E7              jsr   addlist                  ;add to this list
1487 E875 EE 62 DE              inc   atptid                   ;bump tid
1488 E878 AD 62 DE              lda   atptid                   ;get the trans id
1489 E87B EB                    xba                            ;switch high & low bytes
1490 E87C A0 0D 00              ldy   #atprq_tid               ;offset to tid field
1491 E87F 97 80                 sta   [cmdlist],y              ;save it
1492 E881 20 B7 E9              jsr   sndrqpkt                 ;send out the request packet
1493 E884              rqok                                    ; ;the request was ok, so exit busy
1494 E884 4C 42 E9              jmp   waitdone                 ;general exit routine
1495 E887
1496 E887              badskt                                  ; 
1497 E887 4C 47 E9              jmp   retasynflag              ;and return from there
1498 E88A
1499 E88A                       ENDP 
1500 E88A
1501 E88A              *
1502 E88A              * atplisten
1503 E88A              *
1504 E88A              * this is the socket listener for send requests.
1505 E88A              * it reads the atp header out of the packet.   
1506 E88A              *
1507 E88A
1508 E88A              atplisten PROC 
1509 E88A
1510 E88A              atpls1                                  ; 
1511 E88A C2 30                 rep   #mbit+xbit
1512 E88C                       longa on
1513 E88C                       longi on
1514 E88C F4 E1 E1              pea   databank                 ;set up databank properly
1515 E88F AB                    plb   
1516 E890 AB                    plb   
1517 E891
1518 E891 A2 80 00              ldx   #cmdlist                 ;save zero page from here
1519 E894 A9 28 00              lda   #zplen
1520 E897 20 4B E5              jsr   savezp
1521 E89A A6 80                 ldx   cmdlist
1522 E89C A0 E1 00              ldy   #$00e1                   ;lap header in bank $e1
1523 E89F 86 A0                 stx   laphead
1524 E8A1 84 A2                 sty   laphead+2
1525 E8A3 D4 A1                 pei   laphead+1                ;push bytes 2 & 3 (3=$e1)
1526 E8A5 AB                    plb                            ;discard byte 2
1527 E8A6 AB                    plb                            ;and get bank e1
1528 E8A7 9C 42 DA              stz   status                   ;assume no error for return   
1529 E8AA 20 95 F0              jsr   readatpheader            ;read in the header to known location
1530 E8AD E2 30                 sep   #mbit+xbit               ;make sure 8 bit x,a
1531 E8AF                       longa off
1532 E8AF                       longi off
1533 E8AF
1534 E8AF D0 21                 bne   dumprest                 ;error so ignore this packet
1535 E8B1 AD 0A DA              lda   atpheader                ;get the function code
1536 E8B4 29 C0                 and   #$C0                     ;strip unwanted bits
1537 E8B6 C9 80                 cmp   #$80                     ;check for reply
1538 E8B8 D0 18                 bne   dumprest                 ;nope
1539 E8BA F4 27 DE              pea   rqhead-atprq_link        ;address of head for list routines
1540 E8BD F4 E6 F2              pea   rsptable                 ;push response table address
1541 E8C0 A0 23                 ldy   #atprq_link              ;link offset
1542 E8C2 20 B1 E7              jsr   looklist                 ;look for a match
1543 E8C5 E2 30                 sep   #mbit+xbit               ;make sure 8 bit x,a
1544 E8C7 F0 09                 beq   dumprest                 ;no match found so throw out packet
1545 E8C9              *
1546 E8C9              * cmdlist now contains address of node that matched
1547 E8C9              *
1548 E8C9
1549 E8C9 AD 0B DA              lda   atpheader+1              ;get sequence number
1550 E8CC A0 19                 ldy   #atprq_rbnum             ;for compare against num of
1551 E8CE D7 80                 cmp   [cmdlist],y              ;buffers
1552 E8D0 90 15                 bcc   goodsofar1               ;so far its ok
1553 E8D2              dumprest                                ; ;throw out packet
1554 E8D2 C2 20                 rep   #mbit                    ;16 bit A.
1555 E8D4 38                    sec                            ;use internal mode of call
1556 E8D5                       longa on
1557 E8D5 A9 00 80              lda   #$8000                   ;Set purge bit, read 0 bytes
1558 E8D8                       longa off
1559 E8D8 20 D6 F5              jsr   LAPRead                  ;and purge packet
1560 E8DB
1561 E8DB                       entry doneatp                  ; EXPORT -> ENTRY  **TGH
1562 E8DB              doneatp                                 ;
1563 E8DB
1564 E8DB C2 30                 rep   #mbit+xbit               ;make sure 16 bit mode
1565 E8DD                       longa on
1566 E8DD                       longi on
1567 E8DD
1568 E8DD A0 80 00              ldy   #cmdlist                 ;restore from here
1569 E8E0 A9 28 00              lda   #zplen
1570 E8E3 20 72 E5              jsr   restorezp
1571 E8E6 6B                    rtl                            ;and return
1572 E8E7
1573 E8E7              goodsofar1                              ; 
1574 E8E7
1575 E8E7                       longa off
1576 E8E7                       longi off
1577 E8E7 AA                    tax                            ;transfer sequence num
1578 E8E8 BF 18 F3 FD           lda   >onebitmask,x            ;get mask from table
1579 E8EC A0 21                 ldy   #atprq_bitmap            ;go to bitmap field
1580 E8EE 37 80                 and   [cmdlist],y              ;see if wanted
1581 E8F0 F0 E0                 beq   dumprest                 ;nope so leave
1582 E8F2
1583 E8F2 C2 30                 rep   #mbit+xbit               ;16 bit x,a
1584 E8F4                       longa on
1585 E8F4                       longi on
1586 E8F4
1587 E8F4 8A                    txa                            ;get back sequence number
1588 E8F5 0A                    asl   a                        ;*2
1589 E8F6 0A                    asl   a                        ;*4
1590 E8F7 48                    pha                            ;hold temporarily
1591 E8F8 0A                    asl   a                        ;now a=a*8, carry is clear
1592 E8F9 63 01                 adc   $1,s                     ;add a*4 to get a=a*12
1593 E8FB FA                    plx                            ;discard stack temp
1594 E8FC A0 1A 00              ldy   #atprq_rbdsad            ;offset to rddsad pointer
1595 E8FF 20 A4 F0              jsr   readrbds                 ;read data into rbds
1596 E902 D0 D7                 bne   doneatp                  ;bad read so ignore
1597 E904 E2 30                 sep   #mbit+xbit               ;back to 8 bit mode
1598 E906                       longa off
1599 E906                       longi off
1600 E906
1601 E906 A0 22                 ldy   #atprq_response          ;move to responses received fld
1602 E908 B7 80                 lda   [cmdlist],y              ;get previous value
1603 E90A 1A                    inc   a                        ;add 1
1604 E90B 97 80                 sta   [cmdlist],y              ;and put back new value
1605 E90D A0 21                 ldy   #atprq_bitmap            ;update bitmap
1606 E90F AE 0B DA              ldx   atpheader+1              ;get sequence number
1607 E912 AD 0A DA              lda   atpheader                ;get flags
1608 E915 29 10                 and   #atpeombit               ;see if eom
1609 E917 F0 08                 beq   clearbit                 ;nope so just set bitmap
1610 E919 BF 20 F3 FD           lda   >lowbitmask,x            ;get mask for this sequence number
1611 E91D 37 80                 and   [cmdlist],y              ;see if all bits below are zero
1612 E91F 80 06                 bra   newbitmap                ;store new bitmap
1613 E921 BF 18 F3 FD  clearbit lda   >onebitmask,x            ;get bit to set
1614 E925 57 80                 eor   [cmdlist],y              ;flip what was there
1615 E927 97 80        newbitmap sta   [cmdlist],y             ;and store the new one
1616 E929 08                    php                            ;save result of bitmap stuff
1617 E92A AD 0A DA              lda   atpheader                ;get flag byte again
1618 E92D 29 08                 and   #atpstsbit               ;see if status wanted
1619 E92F F0 03                 beq   checkdone                ;no, so see if done with packet
1620 E931 20 B7 E9              jsr   sndrqpkt                 ;re-send request packet
1621 E934 28           checkdone plp                           ;get status from bitmap back
1622 E935 D0 09                 bne   listendone               ;still bits set so leave
1623 E937 C2 30                 rep   #mbit+xbit               ;make sure full 16 bit mode
1624 E939 AD 42 DA              lda   status                   ;call is done so complete
1625 E93C 22 20 EA FD           jsl   killrequest              ;by killing the request
1626 E940 80 99        listendone bra   doneatp                ;back to caller
1627 E942
1628 E942
1629 E942                       ENDP 
1630 E942
1631 E942
1632 E942              *
1633 E942              * waitdone
1634 E942              *
1635 E942              * indicate a call is busy
1636 E942              *
1637 E942
1638 E942              waitdone PROC 
1639 E942
1640 E942 C2 30                 rep   #mbit+xbit               ;16 bit x,a
1641 E944                       longa on
1642 E944                       longi on
1643 E944
1644 E944 A9 FF 05              lda   #atpbusy                 ;show busy first
1645 E947
1646 E947                       entry retasynflag              ; EXPORT -> ENTRY  **TGH
1647 E947              retasynflag                             ;       ;alternate entry point
1648 E947
1649 E947 C2 30                 rep   #mbit+xbit               ;make sure 16 bit x,a
1650 E949
1651 E949 A0 02 00              ldy   #atprq_result            ;offset to result byte
1652 E94C 97 80                 sta   [cmdlist],y              ;save it
1653 E94E 20 E0 F9              jsr   permit                   ;back down interrupt hold off
1654 E951
1655 E951 E2 30                 sep   #mbit+xbit               ;go to 8 bit x,a
1656 E953                       longa off
1657 E953                       longi off
1658 E953
1659 E953 09 00                 ora   #00                      ;test low byte to set status bits
1660 E955 10 01                 bpl   procdone                 ;if positive we are done
1661 E957
1662 E957              goback                                  ; 
1663 E957 6B                    rtl                            ;return long to dispatcher
1664 E958
1665 E958              procdone                                ; 
1666 E958              *                                       ;fall through to io completion stuff
1667 E958
1668 E958                       entry chkiocmp                 ; EXPORT -> ENTRY  **TGH
1669 E958              chkiocmp                                ;another alternate entry point
1670 E958
1671 E958 E2 30                 sep   #mbit+xbit               ;again force 8 bit x,a
1672 E95A
1673 E95A A7 80                 lda   [cmdlist]                ;get async flag
1674 E95C 10 F9                 bpl   goback                   ;not async so no completion routine
1675 E95E A0 02                 ldy   #atprq_result
1676 E960 B7 80                 lda   [cmdlist],y              ;get result
1677 E962 30 F3                 bmi   goback                   ;not completed yet
1678 E964 A0 04                 ldy   #atprq_iocomp            ;offset to completion routine
1679 E966
1680 E966                       entry callcomp                 ; EXPORT -> ENTRY  **TGH
1681 E966              callcomp                                ;       ;come here if y already set
1682 E966
1683 E966 C2 30                 rep   #mbit+xbit               ;back to full 16 bit mode
1684 E968                       longa on
1685 E968                       longi on
1686 E968
1687 E968 AA                    tax                            ;hold onto a
1688 E969 B7 80                 lda   [cmdlist],y              ;get low word
1689 E96B 85 84                 sta   execaddr
1690 E96D C8                    iny   
1691 E96E C8                    iny                            ;bump to high word
1692 E96F B7 80                 lda   [cmdlist],y
1693 E971 85 86                 sta   execaddr+2               ;save high word
1694 E973 05 84                 ora   execaddr                 ;check against low word
1695 E975 F0 E0                 beq   goback                   ;no completion routine wanted
1696 E977              * now, since we are temporarily giving up control, we must make
1697 E977              * sure we preserve the next field, since it was possible that
1698 E977              * we were in the middle of scanning a list when we called this
1699 E977              * routine.  This way, if the next node happens to be deleted
1700 E977              * the delete routine will have a value on the special nextstack
1701 E977              * that it can update to reflect the 'real' next node
1702 E977 20 37 E7              jsr   pushcurr                 ;save next value
1703 E97A AD 44 DA              lda   ysave                    ;get y offset to link
1704 E97D 48                    pha   
1705 E97E 22 8A E9 FD           jsl   gocomp                   ;call completion routine
1706 E982 7A                    ply                            ;recover y offset to link
1707 E983 8C 44 DA              sty   ysave                    ;restore ysave since it could have gotten changed
1708 E986 20 4C E7              jsr   pullcurr                 ;recover value (possibly changed)
1709 E989 6B                    rtl                            ;and return
1710 E98A
1711 E98A
1712 E98A                       EXPORT gocomp 
1713 E98A              gocomp                                  ;       ;general completion routine
1714 E98A              *
1715 E98A              * passes value in x
1716 E98A              *
1717 E98A C2 30                 rep   #mbit+xbit               ;force full native
1718 E98C                       longa on
1719 E98C                       longi on
1720 E98C
1721 E98C 3B                    tsc   
1722 E98D AA                    tax                            ;save stack for return
1723 E98E A5 86                 lda   execaddr+2               ;get high word
1724 E990 F0 0C                 beq   callemul                 ;calling bank 0, do so in emulation
1725 E992 DA                    phx                            ;save current stack for return
1726 E993 8B                    phb   
1727 E994 22 46 10 E1           jsl   Cnxxgo                   ;call exec address, full native
1728 E998              xxx                                     ; 
1729 E998 C2 30                 rep   #mbit+xbit               ;full native
1730 E99A AB                    plb   
1731 E99B 68                    pla                            ;recover full stack pointer
1732 E99C 1B                    tcs                            ;and use it
1733 E99D 6B                    rtl                            ;and return
1734 E99E
1735 E99E              callemul                                ; ;call completion in emulation mode
1736 E99E E0 00 02              cpx   #$0200                   ;see if out of emulation range
1737 E9A1 90 0B                 bcc   stackok                  ;no, stack is ok
1738 E9A3 AF 00 01 01           lda   >emulstack               ;get emulation stack
1739 E9A7 29 FF 00              and   #$00ff                   ;strip out high word
1740 E9AA 09 00 01              ora   #$0100                   ;and put stack in page 1
1741 E9AD 1B                    tcs                            ;set new stack
1742 E9AE 38           stackok  sec                            ;call Cnxx with carry set for emulation
1743 E9AF DA                    phx   
1744 E9B0 8B                    phb   
1745 E9B1 22 42 10 E1           jsl   Cnxx
1746 E9B5 80 E1                 bra   xxx
1747 E9B7
1748 E9B7              * the following c7 code belongs in the c700 space of the appletalk card
1749 E9B7              *c7xx	anop		;switch into emulation mode
1750 E9B7              *	xce
1751 E9B7              * use following code when code is in rom (leave out for testing)
1752 E9B7              *	pei	execaddr+1	;push 2 & 3 rd bytes
1753 E9B7              *	plb
1754 E9B7              *	plb		;set db to same as pb in execaddr
1755 E9B7              *c7xxgo	anop
1756 E9B7              *	jml	(execaddr)	;call the stinking routine
1757 E9B7              *
1758 E9B7              *
1759 E9B7              * completion routine must jump directly here (no rts or rtl)
1760 E9B7              *
1761 E9B7              *c7xxret	anop
1762 E9B7              *	clc
1763 E9B7              *	xce
1764 E9B7              *	rtl		;and return
1765 E9B7
1766 E9B7
1767 E9B7                       ENDP 
1768 E9B7
1769 E9B7              *
1770 E9B7              * sndrqpkt
1771 E9B7              * sends out an atp request packet
1772 E9B7              *
1773 E9B7
1774 E9B7              sndrqpkt PROC 
1775 E9B7
1776 E9B7
1777 E9B7 E2 30                 sep   #mbit+xbit               ;force 8 bit x,a
1778 E9B9                       longa off
1779 E9B9                       longi off
1780 E9B9
1781 E9B9 A0 1F                 ldy   #atprq_interval          ;time interval for retran
1782 E9BB B7 80                 lda   [cmdlist],y
1783 E9BD A0 27                 ldy   #atprq_timeleft
1784 E9BF 97 80                 sta   [cmdlist],y              ;reset timeout counter
1785 E9C1 A0 1E                 ldy   #atprq_flag
1786 E9C3 B7 80                 lda   [cmdlist],y              ;get flag value
1787 E9C5 29 20                 and   #atpxobit                ;strip all but xo bit
1788 E9C7 09 40                 ora   #$40                     ;and make it a request
1789 E9C9              *
1790 E9C9              * now fall through to the generic
1791 E9C9              * send atp packet routine
1792 E9C9              *
1793 E9C9                       entry sndatppkt                ; EXPORT -> ENTRY  **TGH
1794 E9C9              sndatppkt                               ;       ;alternate entry point
1795 E9C9
1796 E9C9 E2 30                 sep   #mbit+xbit               ;force 8 bit x,a
1797 E9CB
1798 E9CB 8D 0A DA              sta   atpheader                ;store command byte
1799 E9CE A0 21                 ldy   #atprq_bitmap
1800 E9D0 B7 80                 lda   [cmdlist],y              ;get the bitmap
1801 E9D2 8D 0B DA              sta   atpheader+1              ;and put in parm list
1802 E9D5 C2 31                 rep   #mbit+xbit+cbit          ;back to 16 bit x,a, clear carry
1803 E9D7                       longa on
1804 E9D7                       longi on
1805 E9D7
1806 E9D7 A5 80                 lda   cmdlist                  ;get low word
1807 E9D9 69 0F 00              adc   #atprq_bufsize           ;add in offset to user data  
1808 E9DC 85 A4                 sta   bdsptr                   ;to get fake bds pointer
1809 E9DE A5 82                 lda   cmdlist+2                ;get high word
1810 E9E0 69 00 00              adc   #00                      ;add in carry bit
1811 E9E3 85 A6                 sta   bdsptr+2                 ;now bds points to parm list
1812 E9E5 A9 FF 00              lda   #$00ff                   ;tell write that we did bds already
1813 E9E8 20 10 F1              jsr   watppkt                  ;write atp packet
1814 E9EB 60           goodsend rts                            ;and return to our caller (internal)
1815 E9EC                       ENDP 
1816 E9EC
1817 E9EC
1818 E9EC              *
1819 E9EC              * atp.killrequest
1820 E9EC              *
1821 E9EC
1822 E9EC              *
1823 E9EC              * cancelreq
1824 E9EC              *
1825 E9EC              * this call removes a request from the request pending
1826 E9EC              * list, and calls a completion routine if necessary.
1827 E9EC              * It only expects to be passed a tid, that it will match
1828 E9EC              * to an item in the list.  It then deletes that item.
1829 E9EC              *
1830 E9EC
1831 E9EC              cancelreq PROC 
1832 E9EC
1833 E9EC                       longa on
1834 E9EC                       longi on
1835 E9EC C2 30                 rep   #mbit+xbit               ;full native
1836 E9EE
1837 E9EE 20 B8 F9              jsr   forbid                   ;don't bother us in here
1838 E9F1 A0 02 00              ldy   #creq_result             ;assume good call
1839 E9F4 A9 00 00              lda   #noatperr                ;so store no error
1840 E9F7 97 80                 sta   [cmdlist],y
1841 E9F9 A5 80                 lda   cmdlist
1842 E9FB 85 A0                 sta   laphead                  ;set up for looklist routine
1843 E9FD A5 82                 lda   cmdlist+2
1844 E9FF 85 A2                 sta   laphead+2
1845 EA01 F4 27 DE              pea   rqhead-atprq_link        ;this is the list to search
1846 EA04 F4 F8 F2              pea   canceltable              ;this is the match table
1847 EA07 A0 23 00              ldy   #atprq_link              ;offset to link field
1848 EA0A 20 B1 E7              jsr   looklist                 ;look it up
1849 EA0D F0 0B                 beq   nomatch                  ;not in list
1850 EA0F A9 07 05              lda   #reqabort                ;show request aborted
1851 EA12 22 20 EA FD           jsl   killrequest              ;kill the request officially
1852 EA16 20 E0 F9              jsr   permit                   ;allow ints again
1853 EA19 6B                    rtl                            ;and return
1854 EA1A              nomatch                                 ; 
1855 EA1A A9 03 05              lda   #noatpcb                 ;control block not found
1856 EA1D 4C 47 E9              jmp   retasynflag              ;does permit for us
1857 EA20
1858 EA20
1859 EA20              *
1860 EA20              * killrequest
1861 EA20              *
1862 EA20              * this call cancels a pending sendrequest by removing
1863 EA20              * it from the rqhead list if it exists.  It then calls
1864 EA20              * a completion routine if there is one to be executed.
1865 EA20              * Also, on exactly once packets it sends a release before
1866 EA20              * exiting.
1867 EA20              *
1868 EA20                       entry killrequest              ; EXPORT -> ENTRY  **TGH
1869 EA20              killrequest                             ;
1870 EA20
1871 EA20                       longa on
1872 EA20                       longi on
1873 EA20 C2 30                 rep   #mbit+xbit
1874 EA22 48                    pha                            ;save result
1875 EA23 F4 27 DE              pea   rqhead-atprq_link        ;search through this list
1876 EA26 A0 23 00              ldy   #atprq_link              ;offset to link field
1877 EA29 20 5C EA              jsr   delitem                  ;and remove cmdlist
1878 EA2C F0 23                 beq   killexit                 ;nothing deleted
1879 EA2E 68                    pla                            ;adjust stack
1880 EA2F              killonly                                ;kill without delete
1881 EA2F 48                    pha                            ;save error code
1882 EA30 C9 01 05              cmp   #largeatp                ;see if atp too large err
1883 EA33 F0 13                 beq   closeskt                 ;yes so don't send release
1884 EA35 A0 1E 00              ldy   #atprq_flag
1885 EA38 B7 80                 lda   [cmdlist],y              ;get flag
1886 EA3A 29 20 00              and   #atpxobit                ;see if xo mode
1887 EA3D F0 09                 beq   closeskt                 ;nope so close and leave
1888 EA3F A9 C0 00              lda   #$c0                     ;send release
1889 EA42 20 C9 E9              jsr   sndatppkt                ;packet
1890 EA45 80 01                 bra   closeskt
1891 EA47
1892 EA47 48           kill     pha   
1893 EA48
1894 EA48 E2 30        closeskt sep   #mbit+xbit
1895 EA4A                       longa off
1896 EA4A                       longi off
1897 EA4A
1898 EA4A A0 08                 ldy   #atprq_dymskt
1899 EA4C B7 80                 lda   [cmdlist],y              ;get socket of this list
1900 EA4E 20 F4 EF              jsr   closeddpskt              ;close the socket
1901 EA51              killexit                                ; 
1902 EA51 C2 30                 rep   #mbit+xbit
1903 EA53                       longa on
1904 EA53                       longi on
1905 EA53
1906 EA53 68                    pla                            ;recover error code
1907 EA54 A0 02 00              ldy   #atprq_result
1908 EA57 97 80                 sta   [cmdlist],y              ;save result
1909 EA59 4C 58 E9              jmp   chkiocmp                 ;do i/o completion, and return
1910 EA5C
1911 EA5C
1912 EA5C              *
1913 EA5C              * delitem
1914 EA5C              * 
1915 EA5C              * this routine deletes the item in the list that is passed us that
1916 EA5C              * cmdlist contains.
1917 EA5C              * the address of the list head is passed on the stack
1918 EA5C              *
1919 EA5C                       entry delitem                  ; EXPORT -> ENTRY  **TGH
1920 EA5C              delitem                                 ;
1921 EA5C
1922 EA5C                       longa on
1923 EA5C                       longi on
1924 EA5C C2 30                 rep   #mbit+xbit               ;force 16 bit x,a
1925 EA5E
1926 EA5E 9C 14 DA              stz   lookflag                 ;nothing found yet
1927 EA61 68                    pla                            ;get return address
1928 EA62 85 94                 sta   R0                       ;hold in temp
1929 EA64 F4 70 EA              pea   delspec                  ;special delete routine
1930 EA67 20 A3 E6              jsr   listmanager              ;loop through this list
1931 EA6A D4 94                 pei   R0                       ;restore return
1932 EA6C AD 14 DA              lda   lookflag                 ;and set condition codes
1933 EA6F 60                    rts                            ;and return
1934 EA70
1935 EA70              delspec                                 ; ;comes here for each node
1936 EA70 A5 80                 lda   cmdlist
1937 EA72 C5 8C                 cmp   curr                     ;see if match found
1938 EA74 D0 0E                 bne   donext                   ;keep looking
1939 EA76 A5 82                 lda   cmdlist+2                ;check high word
1940 EA78 C5 8E                 cmp   curr+2
1941 EA7A D0 08                 bne   donext                   ;no match
1942 EA7C 20 FB E6              jsr   dodelete                 ;delete a node
1943 EA7F 38                    sec                            ;and stop
1944 EA80 EE 14 DA              inc   lookflag                 ;show that it was found
1945 EA83 60                    rts   
1946 EA84 18           donext   clc                            ;skip this one
1947 EA85 60                    rts   
1948 EA86
1949 EA86
1950 EA86
1951 EA86              *
1952 EA86              * atptimer
1953 EA86              *
1954 EA86              * this routine is called directly by the 1/4 sec scheduler
1955 EA86              * and is responsible for updating and maintaining
1956 EA86              * the linked lists (decrementing timers, retrans, etc).
1957 EA86              *
1958 EA86              *
1959 EA86
1960 EA86                       entry atptimer                 ; EXPORT -> ENTRY  **TGH
1961 EA86              atptimer                                ;assume comes here in full native
1962 EA86
1963 EA86                       longa on
1964 EA86                       longi on
1965 EA86
1966 EA86 F4 27 DE              pea   rqhead-atprq_link        ;scan this list
1967 EA89 F4 D3 EA              pea   rqscan                   ;request list scanner
1968 EA8C A0 23 00              ldy   #atprq_link              ;offset to link field
1969 EA8F 20 A3 E6              jsr   listmanager              ;scan the list
1970 EA92 F4 52 DE              pea   rspcbhead-rspcb_link     ;check for expire of xo
1971 EA95 F4 9F EA              pea   rspscan                  ;timer
1972 EA98 A0 00 00              ldy   #rspcb_link
1973 EA9B 20 A3 E6              jsr   listmanager
1974 EA9E
1975 EA9E 60                    rts                            ;and return to our caller
1976 EA9F
1977 EA9F
1978 EA9F              rspscan                                 ; 
1979 EA9F                       longa off
1980 EA9F                       longi off
1981 EA9F E2 31                 sep   #mbit+xbit+cbit          ;
1982 EAA1
1983 EAA1 A0 0F                 ldy   #rspcb_timeout
1984 EAA3 B7 8C                 lda   [curr],y                 ;get timeout for this rspcb
1985 EAA5 ED 40 DA              sbc   decval                   ;number of ticks that have occured
1986 EAA8 F0 06                 beq   gone                     ;it went to zero
1987 EAAA 90 04                 bcc   gone                     ;it went minus
1988 EAAC 97 8C                 sta   [curr],y                 ;otherwise, just store new value
1989 EAAE              gonext                                  ; ;on to next item
1990 EAAE 18                    clc                            ;skip to next item
1991 EAAF 60                    rts   
1992 EAB0
1993 EAB0              gone                                    ; ;remove the node
1994 EAB0
1995 EAB0 C2 30                 rep   #mbit+xbit
1996 EAB2                       longa on
1997 EAB2                       longi on
1998 EAB2
1999 EAB2 A5 8C                 lda   curr
2000 EAB4 85 80                 sta   cmdlist
2001 EAB6 A5 8E                 lda   curr+2
2002 EAB8 85 82                 sta   cmdlist+2
2003 EABA 20 72 ED              jsr   relcb1                   ;free up memory and get sndresponse
2004 EABD 08                    php                            ;save result from release
2005 EABE A0 00 00              ldy   #rspcb_link
2006 EAC1 20 FB E6              jsr   dodelete                 ;delete the node
2007 EAC4 28                    plp                            ;get result back from release
2008 EAC5 F0 E7                 beq   gonext                   ;no sndresponse was attached
2009 EAC7 20 B8 F9              jsr   forbid                   ;balance with permit in retasynflag
2010 EACA A9 05 05              lda   #noatprel                ;no release ever received
2011 EACD 22 47 E9 FD           jsl   retasynflag
2012 EAD1 80 DB                 bra   gonext                   ;and go to next item
2013 EAD3
2014 EAD3
2015 EAD3
2016 EAD3              rqscan                                  ; ;this is where we check the rq list
2017 EAD3 A5 8C                 lda   curr
2018 EAD5 85 80                 sta   cmdlist                  ;move it since others expect it here
2019 EAD7 A5 8E                 lda   curr+2
2020 EAD9 85 82                 sta   cmdlist+2
2021 EADB
2022 EADB                       longa off
2023 EADB                       longi off
2024 EADB E2 31                 sep   #mbit+xbit+cbit          ;go to 8 bit mode
2025 EADD
2026 EADD A0 27                 ldy   #atprq_timeleft          ;check retran timer
2027 EADF B7 80                 lda   [cmdlist],y
2028 EAE1 ED 40 DA              sbc   decval                   ;subtract number of ticks
2029 EAE4 97 80                 sta   [cmdlist],y              ;save result
2030 EAE6 F0 02                 beq   sendagain                ;send it again and dec trysleft
2031 EAE8 B0 10                 bcs   rqnext                   ;not down to zero yet
2032 EAEA              sendagain                               ; 
2033 EAEA A0 28                 ldy   #atprq_trysleft          ;now dec number of tries
2034 EAEC B7 80                 lda   [cmdlist],y              ;if it is not $ff or $00
2035 EAEE F0 0C                 beq   kickout                  ;get rid of this one
2036 EAF0 3A                    dec   a                        ;back it up
2037 EAF1 C9 FE                 cmp   #$fe                     ;see if was $ff
2038 EAF3 F0 02                 beq   sendit                   ;yep, so don't dec & do send
2039 EAF5 97 80                 sta   [cmdlist],y              ;save new value
2040 EAF7 20 B7 E9     sendit   jsr   sndrqpkt                 ;send the packet
2041 EAFA              rqnext                                  ; 
2042 EAFA 18                    clc                            ;skip to next one
2043 EAFB 60                    rts   
2044 EAFC              kickout                                 ; 
2045 EAFC                       longa on
2046 EAFC                       longi on
2047 EAFC C2 30                 rep   #mbit+xbit
2048 EAFE A0 23 00              ldy   #atprq_link              ;offset to link field
2049 EB01 20 FB E6              jsr   dodelete                 ;delete it
2050 EB04 A9 08 05              lda   #requestfail             ;timeout without response
2051 EB07 22 47 EA FD           jsl   kill                     ;pkt already deleted, kill only
2052 EB0B 80 ED                 bra   rqnext                   ;go on to next packet
2053 EB0D
2054 EB0D
2055 EB0D              *
2056 EB0D              * atp.sndresponse
2057 EB0D              *
2058 EB0D                       entry sendresponse             ; EXPORT -> ENTRY  **TGH
2059 EB0D              sendresponse                            ;
2060 EB0D
2061 EB0D                       longa off
2062 EB0D                       longi off
2063 EB0D E2 30                 sep   #mbit+xbit
2064 EB0F
2065 EB0F 20 B8 F9              jsr   forbid                   ;don't allow interrupts
2066 EB12 A0 08                 ldy   #sdrsp_sskt
2067 EB14 B7 80                 lda   [cmdlist],y
2068 EB16 20 B2 F1              jsr   checkskt                 ;see if ok socket
2069 EB19 D0 1F                 bne   doerr1                   ;we got an error so leave
2070 EB1B              goodsocket                              ; 
2071 EB1B              * NOTE: it is up to the user to properly set the bitmap.
2072 EB1B              *
2073 EB1B E2 30                 sep   #mbit+xbit
2074 EB1D                       longa off
2075 EB1D                       longi off
2076 EB1D A0 15                 ldy   #sdrsp_flag              ;get xo flag
2077 EB1F B7 80                 lda   [cmdlist],y
2078 EB21 29 20                 and   #atpxobit                ;and isolate xo bit
2079 EB23 F0 12                 beq   csendrsp                 ;just send it
2080 EB25 20 47 EB              jsr   attachrspcb              ;see if we can attach to a rspcb
2081 EB28 C2 30                 rep   #mbit+xbit               ;make sure full native
2082 EB2A                       longa on
2083 EB2A                       longi on
2084 EB2A D0 05                 bne   doxosend                 ;do exactly once send
2085 EB2C A9 03 05              lda   #noatpcb                 ;couldn't find rspcb
2086 EB2F 80 09                 bra   doerr1                   ;and report the error
2087 EB31              doxosend                                ; 
2088 EB31 20 3D EB              jsr   sendrsp                  ;send response packets
2089 EB34 4C 42 E9              jmp   waitdone                 ;and leave
2090 EB37              csendrsp                                ; ;do at least
2091 EB37 20 3D EB              jsr   sendrsp                  ;send it
2092 EB3A              doerr1                                  ; 
2093 EB3A 4C 47 E9              jmp   retasynflag              ;and post it
2094 EB3D
2095 EB3D              sendrsp                                 ; 
2096 EB3D E2 30                 sep   #mbit+xbit
2097 EB3F                       longa off
2098 EB3F                       longi off
2099 EB3F A0 16                 ldy   #sdrsp_bitmap            ;get user supplied bitmap
2100 EB41 B7 80                 lda   [cmdlist],y
2101 EB43 20 81 EB              jsr   sendnrsp                 ;and send the corresponding packets
2102 EB46 60                    rts   
2103 EB47              *
2104 EB47              * attachrspcb
2105 EB47              *
2106 EB47              * looks for a match in the rspcb list, and if found
2107 EB47              * attaches cmdlist to it, also sets up expire timer
2108 EB47              *
2109 EB47
2110 EB47              attachrspcb                             ;
2111 EB47 C2 30                 rep   #mbit+xbit               ;make sure full native
2112 EB49                       longa on
2113 EB49                       longi on
2114 EB49 A5 80                 lda   cmdlist                  ;set up for looklist call
2115 EB4B 85 A0                 sta   laphead
2116 EB4D A5 82                 lda   cmdlist+2
2117 EB4F 85 A2                 sta   laphead+2
2118 EB51 F4 52 DE              pea   rspcbhead-rspcb_link     ;push head of list
2119 EB54 F4 00 F3              pea   attachtable              ;address of match table
2120 EB57 A0 00 00              ldy   #rspcb_link              ;offset to link field
2121 EB5A 20 B1 E7              jsr   looklist                 ;check for a match
2122 EB5D 08                    php                            ;save status
2123 EB5E F0 1F                 beq   notattached              ;nope so wasn't xo
2124 EB60 A0 04 00              ldy   #rspcb_sndptr            ;offset to attach field
2125 EB63 A5 A0                 lda   laphead                  ;now points to sndresponse
2126 EB65 48                    pha                            ;save for later
2127 EB66 97 80                 sta   [cmdlist],y              ;cmdlist now points to rspcb
2128 EB68 C8                    iny   
2129 EB69 C8                    iny   
2130 EB6A A5 A2                 lda   laphead+2
2131 EB6C 48                    pha                            ;save for later
2132 EB6D 97 80                 sta   [cmdlist],y
2133 EB6F
2134 EB6F                       longa off                      ;switch to 8 bit x,a
2135 EB6F                       longi off
2136 EB6F E2 30                 sep   #mbit+xbit
2137 EB71
2138 EB71 A0 0F                 ldy   #rspcb_timeout           ;offset to expire counter
2139 EB73 A9 78                 lda   #rspval                  ;30 seconds
2140 EB75 97 80                 sta   [cmdlist],y
2141 EB77
2142 EB77                       longa on
2143 EB77                       longi on
2144 EB77 C2 30                 rep   #mbit+xbit               ;back to native full
2145 EB79
2146 EB79 68                    pla                            ;recover high word of sndresponse
2147 EB7A 85 82                 sta   cmdlist+2                ;back into cmdlist
2148 EB7C 68                    pla   
2149 EB7D 85 80                 sta   cmdlist                  ;and low word
2150 EB7F              notattached                             ; ;exit point
2151 EB7F 28                    plp                            ;recover processor state
2152 EB80 60                    rts                            ;and return
2153 EB81
2154 EB81                       entry sendnrsp                 ; EXPORT -> ENTRY  **TGH
2155 EB81              sendnrsp                                ;
2156 EB81                       longa off
2157 EB81                       longi off
2158 EB81 E2 30                 sep   #mbit+xbit               ;8 bit x,a
2159 EB83
2160 EB83 48                    pha                            ;save bitmap
2161 EB84 A0 0F                 ldy   #sdrsp_rbnum             ;get number of active responses
2162 EB86 B7 80                 lda   [cmdlist],y
2163 EB88 AA                    tax   
2164 EB89 68                    pla                            ;recover bitmap
2165 EB8A 3F 20 F3 FD           and   >lowbitmask,x            ;and strip unnecessary bits
2166 EB8E 48                    pha                            ;and save bitmap again
2167 EB8F A9 80                 lda   #$80                     ;this is a response packet
2168 EB91 8D 0A DA              sta   atpheader
2169 EB94 A9 FF                 lda   #$ff                     ;no response to start
2170 EB96 8D 0B DA              sta   atpheader+1
2171 EB99 68           sdrsp1   pla                            ;get current bitmap
2172 EB9A F0 44                 beq   sdrsp9                   ;done
2173 EB9C EE 0B DA              inc   atpheader+1              ;bump sequence number
2174 EB9F 4A                    lsr   a                        ;move bit to carry
2175 EBA0 48                    pha                            ;save new bitmap
2176 EBA1 90 F6                 bcc   sdrsp1                   ;no packet for this bit
2177 EBA3 D0 0C                 bne   sdrsp2                   ;not last buffer in sequence
2178 EBA5 A0 15                 ldy   #sdrsp_flag              ;offset to flags
2179 EBA7 B7 80                 lda   [cmdlist],y              ;get the flag
2180 EBA9 29 08                 and   #atpstsbit               ;see if sts wanted
2181 EBAB 0D 0A DA              ora   atpheader                ;set bit if on since last buffer
2182 EBAE 8D 0A DA              sta   atpheader                ;in this sequence
2183 EBB1 AD 0B DA     sdrsp2   lda   atpheader+1              ;get sequence number
2184 EBB4 AA                    tax                            ;hold for a while
2185 EBB5 1A                    inc   a                        ;bump by 1 for test
2186 EBB6 A0 10                 ldy   #sdrsp_tpkts             ;total number of bds's 
2187 EBB8 D7 80                 cmp   [cmdlist],y              ;check against # of packets
2188 EBBA 90 0A                 bcc   sdrsp3                   ;not last so send normally
2189 EBBC D0 DB                 bne   sdrsp1                   ;too big if > # packets (need add)
2190 EBBE A9 10                 lda   #atpeombit               ;last packet so get eom bit
2191 EBC0 0D 0A DA              ora   atpheader                ;and set it
2192 EBC3 8D 0A DA              sta   atpheader
2193 EBC6              sdrsp3                                  ; 
2194 EBC6 A0 15                 ldy   #sdrsp_flag
2195 EBC8 B7 80                 lda   [cmdlist],y              ;get xo bit
2196 EBCA 29 20                 and   #atpxobit                ;and isolate it
2197 EBCC 0D 0A DA              ora   atpheader
2198 EBCF 8D 0A DA              sta   atpheader                ;and save it
2199 EBD2 8A                    txa                            ;get back sequence #
2200 EBD3 0A                    asl   a                        ;*2
2201 EBD4 0A                    asl   a                        ;*4
2202 EBD5 48                    pha                            ;save * 4 value
2203 EBD6 0A                    asl   a                        ;*8
2204 EBD7 63 01                 adc   $1,s                     ;add to * 4 to get * 12
2205 EBD9 FA                    plx                            ;throw away junk
2206 EBDA 20 10 F1              jsr   watppkt                  ;write this packet
2207 EBDD F0 BA                 beq   sdrsp1                   ;no error so keep sending
2208 EBDF 7A                    ply                            ;discard stack junk
2209 EBE0 C2 30        sdrsp9   rep   #mbit+xbit               ;go to full native
2210 EBE2 60                    rts                            ;and return
2211 EBE3
2212 EBE3
2213 EBE3              *
2214 EBE3              * openatpsocket
2215 EBE3              *
2216 EBE3              * opens a ddp socket and sets up a socket listener
2217 EBE3              * to handle incoming requests and releases
2218 EBE3              *
2219 EBE3                       entry openatpsocket            ; EXPORT -> ENTRY  **TGH
2220 EBE3              openatpsocket                           ;
2221 EBE3
2222 EBE3                       longa on
2223 EBE3                       longi on
2224 EBE3
2225 EBE3 20 B8 F9              jsr   forbid
2226 EBE6 A0 04 00              ldy   #opskt_skt               ;get their socket
2227 EBE9 B7 80                 lda   [cmdlist],y
2228 EBEB A2 EB EC              ldx   #rsplstn                 ;our socket listener
2229 EBEE A0 FD 00              ldy   #^rsplstn                ;high word
2230 EBF1 20 C5 EF              jsr   ddpopenskt               ;open the socket
2231 EBF4 D0 0C                 bne   goback                   ;error, so return
2232 EBF6
2233 EBF6                       longa off
2234 EBF6                       longi off
2235 EBF6 E2 30                 sep   #mbit+xbit
2236 EBF8
2237 EBF8 8A                    txa                            ;get socket from open
2238 EBF9 A0 04                 ldy   #opskt_skt
2239 EBFB 97 80                 sta   [cmdlist],y              ;save new socket
2240 EBFD
2241 EBFD                       longa on
2242 EBFD                       longi on
2243 EBFD C2 30                 rep   #mbit+xbit               ;back to full native
2244 EBFF
2245 EBFF A9 00 00              lda   #noatperr                ;no error
2246 EC02 4C 47 E9     goback   jmp   retasynflag              ;return through here (calls permit)
2247 EC05
2248 EC05
2249 EC05              *
2250 EC05              * closeatpsocket
2251 EC05              *
2252 EC05              * closes up an atp socket opened through openatpsocket.
2253 EC05              * This includes removing all references to this socket
2254 EC05              * from any of our lists, and freeing any associated memory. 
2255 EC05              *
2256 EC05                       entry closeatpsocket           ; EXPORT -> ENTRY  **TGH
2257 EC05              closeatpsocket                          ;
2258 EC05
2259 EC05 20 B8 F9              jsr   forbid
2260 EC08
2261 EC08                       longa on
2262 EC08                       longi on
2263 EC08 C2 30                 rep   #mbit+xbit
2264 EC0A A0 02 00              ldy   #clsskt_result
2265 EC0D A9 00 00              lda   #noatperr
2266 EC10 97 80                 sta   [cmdlist],y              ;no error
2267 EC12
2268 EC12                       longa off
2269 EC12                       longi off
2270 EC12 E2 30                 sep   #mbit+xbit
2271 EC14
2272 EC14 A0 04                 ldy   #clsskt_skt
2273 EC16 B7 80                 lda   [cmdlist],y
2274 EC18 85 98                 sta   r1                       ;hold onto skt
2275 EC1A 20 F4 EF              jsr   closeddpskt              ;close socket
2276 EC1D
2277 EC1D                       longa on                       ;comes back in full 16 bit
2278 EC1D                       longi on
2279 EC1D
2280 EC1D F0 03                 beq   closeok                  ;socket closed ok
2281 EC1F 4C 47 E9              jmp   retasynflag              ;return the error
2282 EC22
2283 EC22              closeok                                 ; 
2284 EC22 F4 39 DE              pea   grqhead-getrq_link       ;scan this list
2285 EC25 F4 3E EC              pea   clsgrq                   ;close out grq's
2286 EC28 A0 1D 00              ldy   #getrq_link
2287 EC2B 20 A3 E6              jsr   listmanager
2288 EC2E F4 52 DE              pea   rspcbhead-rspcb_link     ;now remove rspcb's
2289 EC31 F4 66 EC              pea   clsrspcb                 ;remove rspcb's that match
2290 EC34 A0 00 00              ldy   #rspcb_link
2291 EC37 20 A3 E6              jsr   listmanager
2292 EC3A 20 E0 F9              jsr   permit
2293 EC3D 6B                    rtl                            ;and return
2294 EC3E
2295 EC3E              clsgrq                                  ; 
2296 EC3E
2297 EC3E                       longa off
2298 EC3E                       longi off
2299 EC3E E2 30                 sep   #mbit+xbit
2300 EC40
2301 EC40 A0 08                 ldy   #getrq_ourskt
2302 EC42 B7 8C                 lda   [curr],y                 ;get socket from list
2303 EC44 C5 98                 cmp   r1                       ;see if need to delete
2304 EC46 F0 02                 beq   delit                    ;delete it if matches
2305 EC48 18                    clc                            ;skip only
2306 EC49 60                    rts   
2307 EC4A              delit                                   ; 
2308 EC4A C2 30                 rep   #mbit+xbit               ;use full native
2309 EC4C                       longa on
2310 EC4C                       longi on
2311 EC4C
2312 EC4C A5 8C                 lda   curr                     ;put pntr into cmdlist
2313 EC4E 85 80                 sta   cmdlist                  ;since that's where retasynflag
2314 EC50 A5 8E                 lda   curr+2                   ;wants it
2315 EC52 85 82                 sta   cmdlist+2
2316 EC54 A0 1D 00              ldy   #getrq_link
2317 EC57 20 FB E6              jsr   dodelete                 ;delete the node
2318 EC5A              sktclose                                ; ;calls completion routine
2319 EC5A 20 B8 F9              jsr   forbid                   ;balance permit in retasyn
2320 EC5D A9 09 05              lda   #sktclsd                 ;socket was closed
2321 EC60 22 47 E9 FD           jsl   retasynflag              ;set result and do completion
2322 EC64              skipon                                  ; 
2323 EC64 18                    clc                            ;keep going
2324 EC65 60                    rts   
2325 EC66
2326 EC66              clsrspcb                                ; 
2327 EC66 E2 30                 sep   #mbit+xbit
2328 EC68                       longa off
2329 EC68                       longi off
2330 EC68
2331 EC68 A0 08                 ldy   #rspcb_sskt
2332 EC6A B7 8C                 lda   [curr],y
2333 EC6C C5 98                 cmp   r1
2334 EC6E F0 02                 beq   delcb                    ;remove the rspcb
2335 EC70 18                    clc   
2336 EC71 60                    rts   
2337 EC72              delcb                                   ; 
2338 EC72
2339 EC72                       longa on
2340 EC72                       longi on
2341 EC72 C2 30                 rep   #mbit+xbit
2342 EC74
2343 EC74 A5 8C                 lda   curr
2344 EC76 85 94                 sta   r0
2345 EC78 85 80                 sta   cmdlist
2346 EC7A A5 8E                 lda   curr+2
2347 EC7C 85 96                 sta   r0+2
2348 EC7E 85 82                 sta   cmdlist+2
2349 EC80 A0 00 00              ldy   #rspcb_link
2350 EC83 20 FB E6              jsr   dodelete                 ;remove from linked list
2351 EC86 20 60 EE              jsr   freemem                  ;free up the space
2352 EC89 20 3F EE              jsr   getsndrsp                ;get sndrsp that was attached
2353 EC8C F0 D6                 beq   skipon                   ;the snd was never attached
2354 EC8E 80 CA                 bra   sktclose                 ;do completion stuff
2355 EC90
2356 EC90
2357 EC90              *
2358 EC90              * relrspcb
2359 EC90              *
2360 EC90              * call this to manually free a rspcb if you need to.
2361 EC90              *
2362 EC90                       entry relrspcb                 ; EXPORT -> ENTRY  **TGH
2363 EC90              relrspcb                                ;
2364 EC90                       longa on
2365 EC90                       longi on
2366 EC90 C2 30                 rep   #mbit+xbit
2367 EC92
2368 EC92 20 B8 F9              jsr   forbid                   ;don't bother us here
2369 EC95 A0 02 00              ldy   #relcb_result
2370 EC98 A9 00 00              lda   #noatperr
2371 EC9B 97 80                 sta   [cmdlist],y              ;assume no error
2372 EC9D A5 80                 lda   cmdlist
2373 EC9F 85 A0                 sta   laphead                  ;compare against this
2374 ECA1 A5 82                 lda   cmdlist+2
2375 ECA3 85 A2                 sta   laphead+2
2376 ECA5 F4 52 DE              pea   rspcbhead-rspcb_link     ;search through this list
2377 ECA8 F4 10 F3              pea   reltable
2378 ECAB A0 00 00              ldy   #rspcb_link              ;offset to link field
2379 ECAE 20 B1 E7              jsr   looklist
2380 ECB1 F0 0F                 beq   notfound                 ;no match found
2381 ECB3 20 67 ED              jsr   relcb                    ;free the rspcb
2382 ECB6 F0 06                 beq   nosndatt                 ;no send response was attached
2383 ECB8              *
2384 ECB8              * if we need to here, we can put code to call the completion routine
2385 ECB8              * for the sndresponse which is now held in cmdlist
2386 ECB8              *
2387 ECB8 A9 0D 05              lda   #rsprel                  ;close up and complete
2388 ECBB 4C 47 E9              jmp   retasynflag              ;and exit from there
2389 ECBE
2390 ECBE
2391 ECBE 20 E0 F9     nosndatt jsr   permit                   ;permit ints again
2392 ECC1 6B                    rtl                            ;and return
2393 ECC2
2394 ECC2 A9 03 05     notfound lda   #noatpcb                 ;no control block
2395 ECC5 4C 47 E9              jmp   retasynflag              ;and exit with error
2396 ECC8
2397 ECC8              * don't use add since small wanted
2398 ECC8                       IF  small GOTO .tl2
2399 ECC8              *
2400 ECC8              * addresponse
2401 ECC8              *
2402 ECC8                       entry addresponse              ; EXPORT -> ENTRY  **TGH
2403 ECC8              addresponse                             ;       ;add a response to sendrsp
2404 ECC8                       longa on
2405 ECC8                       longi on
2406 ECC8
2407 ECC8                       jsr   forbid
2408 ECC8                       lda   cmdlist                  ;adjust this to account for
2409 ECC8                       sta   laphead
2410 ECC8                       lda   cmdlist+2
2411 ECC8                       sta   laphead+2
2412 ECC8                       pea   rspcbhead-rspcb_link     ;look through rspcb's
2413 ECC8                       pea   addtable                 ;match table for add
2414 ECC8                       ldy   #rspcb_link              ;link field of list to scan
2415 ECC8                       jsr   looklist                 ;and see if we get a match
2416 ECC8                       bne   getsnd                   ;find attached sndrsp         
2417 ECC8                       brl   nosndrsp                 ;there was none
2418 ECC8              getsnd                                  ; 
2419 ECC8                       jsr   getsndrsp                ;sets cmdlist=attached sndresponse
2420 ECC8
2421 ECC8                       longa off
2422 ECC8                       longi off
2423 ECC8 E2 30                 sep   #mbit+xbit
2424 ECCA
2425 ECCA                       ldy   #addrsp_seqnum           ;sequence number of this packet
2426 ECCA                       lda   [laphead],y              ;laphead is pointing to addrsp
2427 ECCA                       ldy   #sdrsp_tpkts             ;see if too many packets
2428 ECCA                       cmp   [cmdlist],y
2429 ECCA                       bcs   badsqnum                 ;bad sequence number
2430 ECCA                       ldy   #sdrsp_rbnum             ;currently active
2431 ECCA                       cmp   [cmdlist],y              ;see if too low
2432 ECCA                       bne   badsqnum                 ;bad sequence number
2433 ECCA                       tax                            ;save for later
2434 ECCA                       inc   a                        ;adjust highest active packet
2435 ECCA                       sta   [cmdlist],y              ;and save as new rbnum
2436 ECCA                       txa                            ;get back real sequence num
2437 ECCA                       asl   a                        ;*2
2438 ECCA                       asl   a                        ;*4
2439 ECCA                       pha                            ;save *4 value
2440 ECCA                       asl   a                        ;*8
2441 ECCA                       adc   $1,s                     ;carry should be clear get *4+*8
2442 ECCA                       ply                            ;discard stack junk
2443 ECCA                       ldy   #sdrsp_rbdsad            ;get offset to rbds
2444 ECCA
2445 ECCA                       rep   #mbit+xbit+cbit          ;go to full native
2446 ECCA                       longa on
2447 ECCA                       longi on
2448 ECCA
2449 ECCA                       and   #$00ff                   ;strip high byte
2450 ECCA                       adc   [cmdlist],y              ;add to low word of rbds
2451 ECCA                       sta   bdsptr
2452 ECCA                       lda   #0000                    ;add high word of 0 to add carry
2453 ECCA                       iny   
2454 ECCA                       iny   
2455 ECCA                       adc   [cmdlist],y
2456 ECCA                       sta   bdsptr+2
2457 ECCA                       clc   
2458 ECCA                       lda   laphead                  ;now get address of packet to add
2459 ECCA                       adc   #addrsp_bsize
2460 ECCA                       sta   r0
2461 ECCA                       lda   laphead+2
2462 ECCA                       adc   #0000
2463 ECCA                       sta   r0+2
2464 ECCA              movebuf  ldy   #bds_bufsize
2465 ECCA              movelp                                  ; 
2466 ECCA                       lda   [r0],y                   ;get source WORD
2467 ECCA                       sta   [bdsptr],y               ;and move WORD
2468 ECCA                       iny                            ;move to next word
2469 ECCA                       iny   
2470 ECCA                       cpy   #bds_actlen              ;stop when >= to this
2471 ECCA                       bcc   movelp                   ;not done yet
2472 ECCA
2473 ECCA                       sep   #mbit+xbit
2474 ECCA                       longi off
2475 ECCA                       longa off
2476 ECCA
2477 ECCA                       inx                            ;now make sequence num 1-8
2478 ECCA                       lda   >onebitmask-1,x          ;set bit in bitmap
2479 ECCA                       ldy   #sdrsp_bitmap
2480 ECCA                       ora   [cmdlist],y
2481 ECCA                       sta   [cmdlist],y
2482 ECCA                       ldy   #addrsp_flag             ;get eom flag
2483 ECCA                       lda   [laphead],y
2484 ECCA                       and   #atpeombit               ;see if eom wanted
2485 ECCA                       beq   adddone                  ;our work is almost done
2486 ECCA                       ldy   #sdrsp_tpkts             ;and update total number of packets
2487 ECCA                       txa                            ;recover sequence number+1
2488 ECCA                       sta   [cmdlist],y              ;and change tpkts
2489 ECCA              adddone                                 ; ;now clean up and leave
2490 ECCA                       ldy   #sdrsp_bitmap            ;get the bitmap
2491 ECCA                       lda   [cmdlist],y
2492 ECCA 20 B8 F9              jsr   sendnrsp                 ;and send out the packets
2493 ECCD
2494 ECCD                       longa on
2495 ECCD                       longi on
2496 ECCD                       rep   #mbit+xbit
2497 ECCD
2498 ECCD                       lda   #noatperr
2499 ECCD              exit                                    ; 
2500 ECCD A0 08 B7              ldy   #addrsp_result
2501 ECD0                       sta   [laphead],y              ;set result
2502 ECD0                       jsr   permit                   ;allow ints again 
2503 ECD0                       rtl                            ;and leave
2504 ECD0
2505 ECD0              badsqnum                                ; 
2506 ECD0                       rep   #mbit+xbit
2507 ECD0                       lda   #invalidseq              ;bad sequence number
2508 ECD0 80 20                 bra   exit                     ;and return
2509 ECD2              nosndrsp                                ; 
2510 ECD2                       rep   #mbit+xbit
2511 ECD2 B2 F1                 lda   #addnosnd                ;trying to add without a send
2512 ECD4                       bra   exit
2513 ECD4              .tl2      
2514 ECD4
2515 ECD4
2516 ECD4
2517 ECD4              *
2518 ECD4              * atp.getrequest
2519 ECD4              *
2520 ECD4              * implements getrequest call
2521 ECD4              * and the associated socket listener
2522 ECD4              *
2523 ECD4                       entry getrequest               ; EXPORT -> ENTRY  **TGH
2524 ECD4              getrequest                              ;
2525 ECD4
2526 ECD4                       longa off
2527 ECD4                       longi off
2528 ECD4                       sep   #mbit+xbit
2529 ECD4
2530 ECD4                       jsr   forbid
2531 ECD4                       ldy   #getrq_ourskt            ;get the socket they got from atp
2532 ECD4                       lda   [cmdlist],y
2533 ECD4                       jsr   checkskt                 ;see if valid
2534 ECD4 F0 03                 beq   @goodsocket              ;yes, ok
2535 ECD6 4C 47 E9              jmp   retasynflag              ;bad, so return with error
2536 ECD9              @goodsocket                             ; 
2537 ECD9
2538 ECD9                       longa on
2539 ECD9                       longi on
2540 ECD9 C2 30                 rep   #mbit+xbit               ;full native mode
2541 ECDB
2542 ECDB F4 39 DE              pea   grqhead-getrq_link       ;head of getrequest list
2543 ECDE D4 82                 pei   cmdlist+2                ;high word of this node
2544 ECE0 D4 80                 pei   cmdlist                  ;low word of this node
2545 ECE2 A0 1D 00              ldy   #getrq_link              ;offset to link field
2546 ECE5 20 6D E7              jsr   addlist                  ;add to get request list
2547 ECE8 4C 42 E9              jmp   waitdone                 ;return with busy flag set
2548 ECEB
2549 ECEB
2550 ECEB              *
2551 ECEB              * rsplstn
2552 ECEB              * this is the socket listener that is called when requests and
2553 ECEB              * releases come to us.  It is responsible for searching rspcb's,
2554 ECEB              * & grq's, and takes the appropriate action
2555 ECEB              *
2556 ECEB                       entry rsplstn                  ; EXPORT -> ENTRY  **TGH
2557 ECEB              rsplstn                                 ;       
2558 ECEB                       longa on
2559 ECEB                       longi on
2560 ECEB
2561 ECEB C2 30                 rep   #mbit+xbit               ;force full native
2562 ECED F4 E1 E1              pea   databank                 ;make sure we are in right bank
2563 ECF0 AB                    plb   
2564 ECF1 AB                    plb   
2565 ECF2 A9 28 00              lda   #zplen                   ;save zero page
2566 ECF5 A2 80 00              ldx   #cmdlist                 ;from here
2567 ECF8 20 4B E5              jsr   savezp
2568 ECFB A6 80                 ldx   cmdlist
2569 ECFD A0 E1 00              ldy   #$00e1                   ;always in e1
2570 ED00 86 A0                 stx   laphead                  ;save address of lapheader
2571 ED02 84 A2                 sty   laphead+2
2572 ED04 D4 A1                 pei   laphead+1                ;push bytes 2 & 3 (3=$e1)
2573 ED06 AB                    plb                            ;discard byte 2
2574 ED07 AB                    plb                            ;and get bank e1
2575 ED08 9C 42 DA              stz   status                   ;assume no error to return
2576 ED0B 20 95 F0              jsr   readatpheader            ;read in the header
2577 ED0E E2 30                 sep   #mbit+xbit               ;make sure 8 bit x,a
2578 ED10                       longa off
2579 ED10                       longi off
2580 ED10
2581 ED10 D0 3D                 bne   dumprest                 ;error so ignore
2582 ED12 AD 0A DA              lda   atpheader                ;get function code
2583 ED15 AA                    tax                            ;make a copy
2584 ED16 0A                    asl   a                        ;check function
2585 ED17 10 36                 bpl   dumprest                 ;ignore it since it's a response
2586 ED19 B0 40                 bcs   release                  ;it's a release
2587 ED1B 8A                    txa                            ;get back original function code
2588 ED1C 29 20                 and   #atpxobit                ;see if xo
2589 ED1E F0 6F                 beq   atprpls4                 ;nope
2590 ED20              * this is an exactly once request, so now it is time to check
2591 ED20              * and see if there is a response matching this packet already
2592 ED20              * waiting in a rspcb.  If so, then we re-tranmit the original
2593 ED20              * response.  Otherwise, if the rspcb exists but does not have
2594 ED20              * a response attached to it, we simply ignore this packet.
2595 ED20              * If no rspcb is found at all, then see if there is a getrequest
2596 ED20              * pending for this packet, and handle it for the getrequest.
2597 ED20              *
2598 ED20 20 2E EE              jsr   lookrspcb                ;look for a match in rspcb list
2599 ED23 F0 6A                 beq   atprpls4                 ;no rspcb so do getrequest check
2600 ED25              * a rspcb was found, so check to see if a response already exists
2601 ED25              * cmdlist now points to the rspcb that matched
2602 ED25 A0 0F                 ldy   #rspcb_timeout           ;re-set timeout 
2603 ED27 A9 78                 lda   #rspval                  ;get initial value
2604 ED29 97 80                 sta   [cmdlist],y              ;save it
2605 ED2B 20 3F EE              jsr   getsndrsp                ;get sndrsp in cmdlist
2606 ED2E
2607 ED2E E2 30                 sep   #mbit+xbit               ;back to 8 bit x,a
2608 ED30
2609 ED30 F0 1D                 beq   dumprest                 ;nothing attached yet so leave
2610 ED32 AD 0B DA              lda   atpheader+1              ;get bitmap from request
2611 ED35 A0 16                 ldy   #sdrsp_bitmap
2612 ED37 37 80                 and   [cmdlist],y              ;and with internal bitmap
2613 ED39 48                    pha                            ;packets to send (save for free pkts)
2614 ED3A 20 81 EB              jsr   sendnrsp                 ;snd pkts they want and we have
2615 ED3D E2 30                 sep   #mbit+xbit               ;make sure 8 bit x,a
2616 ED3F 68                    pla                            ;get packets to send
2617 ED40 AA                    tax                            ;hold for awhile
2618 ED41 A0 16                 ldy   #sdrsp_bitmap            ;get internal bitmap again
2619 ED43 57 80                 eor   [cmdlist],y              ;operation gives us packets to free
2620 ED45 48                    pha                            ;hold on stack
2621 ED46 8A                    txa                            ;get packets to send (new bitmap)
2622 ED47 97 80                 sta   [cmdlist],y              ;save it
2623 ED49 68                    pla                            ;now get packets to free
2624 ED4A F0 03                 beq   dumprest                 ;there are none
2625 ED4C 20 53 EE              jsr   freepkts                 ;call free packets routine
2626 ED4F              dumprest                                ; ;throw out remaining data
2627 ED4F C2 20                 rep   #mbit                    ;16 bit A
2628 ED51 38                    sec                            ;do internal call
2629 ED52                       longa on
2630 ED52 A9 00 80              lda   #$8000                   ;do purge, read 0 bytes
2631 ED55 20 D6 F5              jsr   lapread
2632 ED58                       longa off
2633 ED58              rsplstngoback                           ; 
2634 ED58 4C DB E8              jmp   doneatp                  ;return through common exit
2635 ED5B
2636 ED5B              release                                 ; ;comes here with release pkt
2637 ED5B                       longa on
2638 ED5B                       longi on
2639 ED5B 20 2E EE              jsr   lookrspcb                ;search for a match
2640 ED5E F0 EF                 beq   dumprest                 ;no match so leave
2641 ED60 20 67 ED              jsr   relcb                    ;free this cb
2642 ED63 F0 EA                 beq   dumprest                 ;there was no sndresponse attached
2643 ED65 80 1A                 bra   goodexit                 ;there was a sndresponse to release it
2644 ED67
2645 ED67                       entry relcb                    ; EXPORT -> ENTRY  **TGH
2646 ED67              relcb                                   ;
2647 ED67 C2 30                 rep   #mbit+xbit
2648 ED69 F4 52 DE              pea   rspcbhead-rspcb_link     ;delete from this list
2649 ED6C A0 00 00              ldy   #rspcb_link              ;offset to link
2650 ED6F 20 5C EA              jsr   delitem                  ;remove from list
2651 ED72
2652 ED72                       longa on
2653 ED72                       longi on                       ;comes back in 16 bit mode
2654 ED72
2655 ED72                       entry relcb1                   ; EXPORT -> ENTRY  **TGH
2656 ED72              relcb1                                  ;
2657 ED72 A5 80                 lda   cmdlist                  ;get node to put back on free
2658 ED74 85 94                 sta   r0                       ;list
2659 ED76 A5 82                 lda   cmdlist+2
2660 ED78 85 96                 sta   r0+2                     ;node to free is in r0
2661 ED7A 20 60 EE              jsr   freemem                  ;puts back on list of avail nodes
2662 ED7D 20 3F EE              jsr   getsndrsp                ;gets sendrsp attached to rspcb
2663 ED80 60                    rts                            ;return all set up
2664 ED81
2665 ED81 20 B8 F9     goodexit jsr   forbid                   ;balance permit in retasynflag
2666 ED84 C2 30                 rep   #mbit+xbit               ;16 bit x,a
2667 ED86 AD 42 DA              lda   status                   ;get error code if any    
2668 ED89 22 47 E9 FD           jsl   retasynflag              ;call completion stuff (does permit)
2669 ED8D 80 C0                 bra   dumprest                 ;and return
2670 ED8F              atprpls4                                ; ;check for a matching getrequest
2671 ED8F
2672 ED8F C2 30                 rep   #mbit+xbit               ;make sure full native
2673 ED91
2674 ED91 F4 39 DE              pea   grqhead-getrq_link       ;search the getrequest list
2675 ED94 F4 F6 F2              pea   grqtable                 ;make sure a getrequest is pending
2676 ED97 A0 1D 00              ldy   #getrq_link              ;offset to link
2677 ED9A 20 B1 E7              jsr   looklist                 ;call search routine
2678 ED9D F0 B0                 beq   dumprest                 ;no match found
2679 ED9F              * a match was found, and cmdlist now contains the matching getrequest
2680 ED9F 18                    clc   
2681 EDA0 A5 80                 lda   cmdlist
2682 EDA2 69 0F 00              adc   #getrq_bufsize
2683 EDA5 85 A4                 sta   bdsptr
2684 EDA7 A5 82                 lda   cmdlist+2
2685 EDA9 69 00 00              adc   #^getrq_bufsize
2686 EDAC 85 A6                 sta   bdsptr+2
2687 EDAE 20 B3 F0              jsr   readrbd2                 ;alternate entry if bds already set
2688 EDB1 D0 A5                 bne   rsplstngoback            ;and return, packet already purged
2689 EDB3 D4 82                 pei   cmdlist+2                ;high word
2690 EDB5 D4 80                 pei   cmdlist                  ;low word of destination
2691 EDB7 20 17 EE              jsr   moveinfo                 ;move the data
2692 EDBA
2693 EDBA                       longa off
2694 EDBA                       longi off
2695 EDBA E2 30                 sep   #mbit+xbit
2696 EDBC
2697 EDBC F4 39 DE              pea   grqhead-getrq_link       ;remove from grq list
2698 EDBF A0 1D                 ldy   #getrq_link
2699 EDC1 20 5C EA              jsr   delitem                  ;and delete it
2700 EDC4 E2 30                 sep   #mbit+xbit               ;put back in 8 bit x,a
2701 EDC6
2702 EDC6 A0 1C                 ldy   #getrq_bitmap            ;update bitmap
2703 EDC8 AD 0B DA              lda   atpheader+1
2704 EDCB 97 80                 sta   [cmdlist],y
2705 EDCD A0 1B                 ldy   #getrq_flag              ;update flag field
2706 EDCF AD 0A DA              lda   atpheader                ;get command byte
2707 EDD2 97 80                 sta   [cmdlist],y
2708 EDD4 29 20                 and   #atpxobit                ;isolate this bit
2709 EDD6 F0 A9                 beq   goodexit                 ;all done, not xo
2710 EDD8 20 9F EE              jsr   getmem                   ;get a free node
2711 EDDB F0 2F                 beq   nomem                    ;no memory left
2712 EDDD
2713 EDDD                       longa on                       ;comes back in full native
2714 EDDD                       longi on
2715 EDDD
2716 EDDD A9 00 00              lda   #0000
2717 EDE0 A0 04 00              ldy   #rspcb_sndptr
2718 EDE3 97 94                 sta   [r0],y
2719 EDE5 C8                    iny   
2720 EDE6 C8                    iny   
2721 EDE7 97 94                 sta   [r0],y                   ;clear sndptr field (not attached yet)
2722 EDE9 A0 0F 00              ldy   #rspcb_timeout           ;set initial timeout 
2723 EDEC A9 78 00              lda   #rspval                  ;get initial value
2724 EDEF 08                    php   
2725 EDF0 E2 20                 sep   #mbit                    ;only a one byte value
2726 EDF2 97 94                 sta   [r0],y                   ;and save in parm block
2727 EDF4 28                    plp                            ;restore state
2728 EDF5
2729 EDF5 F4 52 DE              pea   rspcbhead-rspcb_link     ;push parms on stack for second call
2730 EDF8 D4 96                 pei   r0+2                     ;now, since r0 will be destroyed by
2731 EDFA D4 94                 pei   r0                       ;moveinfo
2732 EDFC
2733 EDFC D4 96                 pei   r0+2
2734 EDFE D4 94                 pei   r0
2735 EE00 20 17 EE              jsr   moveinfo                 ;now set up data for this rspcb
2736 EE03 A0 00 00              ldy   #rspcb_link              ;parms are already on stack (above)
2737 EE06 20 6D E7              jsr   addlist                  ;and do it
2738 EE09 82 75 FF              brl   goodexit                 ;do iocomp and leave
2739 EE0C
2740 EE0C              nomem                                   ; ;no memory for rspcb
2741 EE0C C2 30                 rep   #mbit+xbit               ;make sure full native
2742 EE0E A9 02 01              lda   #norspcbmem
2743 EE11 8D 42 DA              sta   status
2744 EE14 82 6A FF              brl   goodexit                 ;call completion routine
2745 EE17
2746 EE17              moveinfo                                ; 
2747 EE17 FA                    plx                            ;get return
2748 EE18 68                    pla                            ;get low word
2749 EE19 85 8C                 sta   curr                     ;set up
2750 EE1B 68                    pla                            ;get high word
2751 EE1C 85 8E                 sta   curr+2
2752 EE1E F4 E6 F2              pea   rspcbtable-sdrsp_sskt    ;calculate base of movetable
2753 EE21 68                    pla                            ;get it back
2754 EE22 85 94                 sta   r0
2755 EE24 4B                    phk   
2756 EE25 4B                    phk                            ;push program bank
2757 EE26 68                    pla                            ;get it back
2758 EE27 85 96                 sta   r0+2                     ;and use for high word
2759 EE29 DA                    phx                            ;restore return addr
2760 EE2A 20 D5 E7              jsr   listmove                 ;do the move
2761 EE2D 60                    rts   
2762 EE2E
2763 EE2E                       entry lookrspcb                ; EXPORT -> ENTRY  **TGH
2764 EE2E              lookrspcb                               ;       
2765 EE2E C2 30                 rep   #mbit+xbit
2766 EE30 F4 52 DE              pea   rspcbhead-rspcb_link     ;search the rspcb list
2767 EE33 F4 EE F2              pea   rspcbtable               ;match table  
2768 EE36 A0 00 00              ldy   #rspcb_link              ;offset to link
2769 EE39 20 B1 E7              jsr   looklist                 ;call search routine
2770 EE3C E2 30                 sep   #mbit+xbit               ;make sure 8 x,a
2771 EE3E 60                    rts   
2772 EE3F
2773 EE3F                       entry getsndrsp                ; EXPORT -> ENTRY  **TGH
2774 EE3F              getsndrsp                               ;       ;puts sndrsp field of rspcb in cmdlist
2775 EE3F                       longa on
2776 EE3F                       longi on
2777 EE3F C2 30                 rep   #mbit+xbit
2778 EE41 A0 04 00              ldy   #rspcb_sndptr            ;check attach field
2779 EE44 B7 80                 lda   [cmdlist],y              ;get low word
2780 EE46 48                    pha                            ;save
2781 EE47 C8                    iny   
2782 EE48 C8                    iny   
2783 EE49 B7 80                 lda   [cmdlist],y              ;get high word
2784 EE4B 85 82                 sta   cmdlist+2                ;new cmdlist is sndrsp
2785 EE4D 68                    pla                            ;get low word
2786 EE4E 85 80                 sta   cmdlist
2787 EE50 05 82                 ora   cmdlist+2                ;see if 0
2788 EE52 60                    rts   
2789 EE53
2790 EE53              *
2791 EE53              * freepkts
2792 EE53              * this routine will call the special routine attached to the sndresponse
2793 EE53              * call for every packet that is no longer needed in the response
2794 EE53              * The ones that are no longer needed are the ones which have been sent
2795 EE53              * and a new bitmap has been returned saying those packets were received
2796 EE53              * if a bit is set in aflag, it means that that packet is now free.
2797 EE53              *
2798 EE53              freepkts                                ; 
2799 EE53                       longa off
2800 EE53                       longi off                      ;comes here in 8 bit mode
2801 EE53
2802 EE53 E2 30                 sep   #mbit+xbit               ;just to be safe
2803 EE55 A0 1B                 ldy   #sdrsp_aflag             ;store the packets to add flag
2804 EE57 97 80                 sta   [cmdlist],y
2805 EE59 A0 17                 ldy   #sdrsp_addrtn            ;offset to routine wanted
2806 EE5B 22 66 E9 FD           jsl   callcomp                 ;and call it
2807 EE5F 60                    rts                            ;and return
2808 EE60
2809 EE60
2810 EE60              *
2811 EE60              * atp.memory
2812 EE60              *
2813 EE60              * this is the memory management stuff
2814 EE60              * that is neccessary to support xo sendresponses
2815 EE60              *
2816 EE60                       entry freemem                  ; EXPORT -> ENTRY  **TGH
2817 EE60              freemem                                 ;free node that is in R0
2818 EE60
2819 EE60                       longa on
2820 EE60                       longi on
2821 EE60 C2 30                 rep   #mbit+xbit
2822 EE62
2823 EE62 AD 4E DE              lda   availhead                ;get low word of head
2824 EE65 87 94                 sta   [r0]                     ;save in low link field
2825 EE67 A0 02 00              ldy   #0002                    ;offset to high link
2826 EE6A AD 50 DE              lda   availhead+2
2827 EE6D 97 94                 sta   [r0],y                   ;save that (r0->link=availhead)
2828 EE6F A5 94                 lda   r0                       ;now get this node
2829 EE71 8D 4E DE              sta   availhead                ;and let availhead = r0
2830 EE74 A5 96                 lda   r0+2
2831 EE76 8D 50 DE              sta   availhead+2              ;node was just released
2832 EE79 60                    rts                            ;by adding to front of availhead
2833 EE7A
2834 EE7A                       entry makefreelist             ; EXPORT -> ENTRY  **TGH
2835 EE7A              makefreelist                            ;       ;create a list of free memory
2836 EE7A
2837 EE7A C2 30                 rep   #mbit+xbit               ;force full native mode
2838 EE7C
2839 EE7C A9 74 DA              lda   #freechunk               ;use fixed memory for now
2840 EE7F 85 94                 sta   r0                       ;but later call memory manager
2841 EE81 A9 E1 00              lda   #^databank               ;for this memory
2842 EE84 85 96                 sta   r0+2                     ;
2843 EE86 A2 20 00              ldx   #512/rspcbsize           ;512 bytes so get as many as we can
2844 EE89              makeloop                                ; 
2845 EE89 20 60 EE              jsr   freemem                  ;free first node
2846 EE8C 18                    clc   
2847 EE8D A5 94                 lda   r0                       ;get low word
2848 EE8F 69 10 00              adc   #rspcbsize               ;move to next entry
2849 EE92 85 94                 sta   r0
2850 EE94 A5 96                 lda   r0+2                     ;get high byte
2851 EE96 69 00 00              adc   #^rspcbsize              ;add high word (always 0)
2852 EE99 85 96                 sta   r0+2                     ;and save result
2853 EE9B CA                    dex                            ;
2854 EE9C D0 EB                 bne   makeloop                 ;add next node to free list
2855 EE9E 60                    rts                            ;and return
2856 EE9F
2857 EE9F                       entry getmem                   ; EXPORT -> ENTRY
2858 EE9F              getmem                                  ;       ;this gets a node from availhead
2859 EE9F
2860 EE9F C2 30                 rep   #mbit+xbit               ;force full native
2861 EEA1
2862 EEA1 F4 4E DE              pea   availhead-0              ;push address of head
2863 EEA4 F4 B6 EE              pea   getspc                   ;getmem special routine
2864 EEA7 64 94                 stz   r0                       ;clear return field
2865 EEA9 64 96                 stz   r0+2                     ;and high byte
2866 EEAB A0 00 00              ldy   #0000                    ;offset to avail link
2867 EEAE 20 A3 E6              jsr   listmanager              ;call list handler
2868 EEB1 A5 94                 lda   r0
2869 EEB3 05 96                 ora   r0+2                     ;set flags for caller (z=1 if no mem)
2870 EEB5 60                    rts                            ;return to caller
2871 EEB6              getspc                                  ; ;special handler
2872 EEB6 A5 8C                 lda   curr                     ;get this node
2873 EEB8 85 94                 sta   r0                       ;and take from list
2874 EEBA A5 8E                 lda   curr+2
2875 EEBC 85 96                 sta   r0+2
2876 EEBE 20 FB E6              jsr   dodelete                 ;delete node and stop
2877 EEC1 38                    sec                            ;stop
2878 EEC2 60                    rts                            ;that's it
2879 EEC3
2880 EEC3              *
2881 EEC3              * atp.qtr
2882 EEC3              *
2883 EEC3              * this is the general quarter second task scheduler
2884 EEC3              * it allows addition and removal of 1/4 second routines
2885 EEC3              * that will be called at user specifiable times.
2886 EEC3              *
2887 EEC3              * NOTE: RemoveQtr is completely re-entrant, and can   
2888 EEC3              * be called whenever a routine is no-longer needed.      
2889 EEC3              * InstallQtr is safe to call when servicing a 1/4 sec
2890 EEC3              * interrupt or AppleTalk packets.  In other words, if
2891 EEC3              * you are in a 1/4 second handler, it is allowable to
2892 EEC3              * call InstallQtr without ill effect.
2893 EEC3              *
2894 EEC3                       entry InstallQtr               ; EXPORT -> ENTRY  **TGH
2895 EEC3              InstallQtr                              ;
2896 EEC3
2897 EEC3                       longa on
2898 EEC3                       longi on
2899 EEC3 C2 30                 rep   #mbit+xbit
2900 EEC5 20 B8 F9              jsr   forbid                   ;don't bother us in here
2901 EEC8
2902 EEC8 A0 08 00              ldy   #insqtr_ticks            ;update tick counter
2903 EECB AD 00 DA              lda   tickcount                ;get global tick count
2904 EECE 97 80                 sta   [cmdlist],y
2905 EED0 A0 0A 00              ldy   #insqtr_count            ;get number of ticks wanted
2906 EED3 B7 80                 lda   [cmdlist],y
2907 EED5 F0 3F                 beq   rqgoback                 ;return only global tick count
2908 EED7
2909 EED7              * always add to the head of the queue, since it is possible that
2910 EED7              * the 1/4 scheduler could be scanning the list when we were called.
2911 EED7              * If the node where appended to the end, it could be called before
2912 EED7              * time had really elapsed!
2913 EED7
2914 EED7 F4 4E DE              pea   qtrhead-insqtr_link      ;add to this list
2915 EEDA D4 82                 pei   cmdlist+2                ;add this item
2916 EEDC D4 80                 pei   cmdlist
2917 EEDE A0 0C 00              ldy   #insqtr_link             ;get offset to link field
2918 EEE1 20 6D E7              jsr   addlist
2919 EEE4 A9 FF 01              lda   #qtrbusy                 ;show that we are in progress
2920 EEE7 4C 47 E9              jmp   retasynflag
2921 EEEA
2922 EEEA                       entry RemoveQtr                ; EXPORT -> ENTRY  **TGH
2923 EEEA              RemoveQtr                               ;       ;delete from list
2924 EEEA C2 30                 rep   #mbit+xbit               ;force 16 bits
2925 EEEC 20 B8 F9              jsr   forbid                   ;no ints in here
2926 EEEF
2927 EEEF F4 4E DE              pea   qtrhead-insqtr_link
2928 EEF2 A0 0C 00              ldy   #insqtr_link
2929 EEF5 20 5C EA              jsr   delitem
2930 EEF8 F0 1F                 beq   rqnotfound               ;error
2931 EEFA A0 01 00              ldy   #rmvqtr_command          ;Load the command number.
2932 EEFD A7 80                 lda   [cmdlist]
2933 EEFF 29 00 FF              and   #$FF00                   ;Only the command number!
2934 EF02 C9 00 45              cmp   #$4500                   ;Is it a cancel or remove?
2935 EF05 D0 0C                 bne   @L1                      ;Branch if remove
2936 EF07
2937 EF07 A7 80                 lda   [cmdlist]
2938 EF09 09 80 00              ora   #$0080
2939 EF0C 87 80                 sta   [cmdlist]
2940 EF0E A9 06 01              lda   #qtrcanceled
2941 EF11 80 03                 bra   rqgoback
2942 EF13
2943 EF13 A9 00 00     @L1      lda   #noqtrerr                ;no error
2944 EF16              rqgoback                                ; 
2945 EF16 4C 47 E9              jmp   retasynflag              ;and return
2946 EF19 A9 03 01     rqnotfound lda   #qtrnotfound
2947 EF1C 80 F8                 bra   rqgoback                 ;return with error
2948 EF1E
2949 EF1E              * this is the quarter second dispatcher
2950 EF1E              * it is called by lap directly, and comes
2951 EF1E              * here with int's disabled
2952 EF1E              *
2953 EF1E                       EXPORT qtrsched 
2954 EF1E              qtrsched                                ;       ;the 1/4 sec scheduler
2955 EF1E AE 68 DE              ldx   atalkon                  ;see if appletalk really active
2956 EF21 F0 6E                 beq   qtrscheddone             ;no, so don't try to dispatch
2957 EF23
2958 EF23 29 FF 00              and   #$00ff                   ;lap only counts low byte as valid
2959 EF26 8D 40 DA              sta   decval                   ;decrement value
2960 EF29 18                    clc   
2961 EF2A 6D 6C DE              adc   intervalticks            ;running ticks in real time interval
2962 EF2D 8D 6C DE              sta   intervalticks            ;save them
2963 EF30
2964 EF30              ;	pea	$0000	;push space for result of readtime
2965 EF30              ;	pea	$0000	;push space for result of readtime
2966 EF30              ;	pea	$0000	;push space for result of readtime
2967 EF30              ;	pea	$0000	;push space for result of readtime
2968 EF30              ;	ldx	#$0d03	;call readtimehex
2969 EF30              ;	jsl	>$e10000
2970 EF30              ;	pla		;get seconds and minutes
2971 EF30              ;	plx
2972 EF30              ;	plx
2973 EF30              ;	plx		;discard other stuff
2974 EF30              ;	and	#$00ff	;just want number of seconds
2975 EF30              ;	tax		;save in case we need it again
2976 EF30
2977 EF30 08                    php   
2978 EF31 E2 30                 sep   #$30
2979 EF33 22 8C 00 E1           jsl   >$E1008C
2980 EF37 28                    plp   
2981 EF38 AF E1 03 E1           lda   >$E103E1
2982 EF3C 29 FF 00              and   #$00FF
2983 EF3F AA                    tax   
2984 EF40
2985 EF40              checktimedif                            ; 
2986 EF40 38                    sec   
2987 EF41 ED 6A DE              sbc   startcount               ;subtract the previous counter
2988 EF44 B0 06                 bcs   numsok                   ;no need to do 60 second adjust
2989 EF46 8A                    txa                            ;recover time again
2990 EF47 69 00 01              adc   #256                     ;add 60 seconds to real time and check for difference
2991 EF4A 80 F4                 bra   checktimedif             ;go check the difference now
2992 EF4C              numsok                                  ; 
2993 EF4C C9 0A 00              cmp   #10                      ;see if above threshold
2994 EF4F 90 15                 bcc   dontadjustyet            ;no, so lets not adjust right now
2995 EF51 8E 6A DE              stx   startcount               ;new counter
2996 EF54 0A                    asl   a                        ;multiply by 4
2997 EF55 0A                    asl   a                        ;to find number of 1/4 seconds
2998 EF56 38                    sec   
2999 EF57 ED 6C DE              sbc   intervalticks            ;see if more ticks need to be dispatched
3000 EF5A 9C 6C DE              stz   intervalticks            ;zero out the interval timer
3001 EF5D 90 07                 bcc   dontadjustyet            ;intervalticks were valid
3002 EF5F 18                    clc   
3003 EF60 6D 40 DA              adc   decval                   ;add to value we just got
3004 EF63 8D 40 DA              sta   decval                   ;dispatch with adjusted tick count
3005 EF66              dontadjustyet                           ; 
3006 EF66 AD 40 DA              lda   decval                   ;get decrement value
3007 EF69 18                    clc   
3008 EF6A 6D 00 DA              adc   tickcount                ;add to old tickcount
3009 EF6D 8D 00 DA              sta   tickcount                ;and save new value
3010 EF70
3011 EF70 A9 28 00              lda   #zplen                   ;entire length of zp used
3012 EF73 A2 80 00              ldx   #cmdlist                 ;base of zp to save
3013 EF76 20 4B E5              jsr   savezp                   ;and save it
3014 EF79
3015 EF79 20 86 EA              jsr   atptimer                 ;our internal routine
3016 EF7C F4 4E DE              pea   qtrhead-insqtr_link      ;scan this list
3017 EF7F F4 92 EF              pea   qtrroutine               ;special routine for each node
3018 EF82 A0 0C 00              ldy   #insqtr_link             ;offset to link
3019 EF85 20 A3 E6              jsr   listmanager              ;do it
3020 EF88
3021 EF88 A9 28 00              lda   #zplen                   ;length of zero page to restore
3022 EF8B A0 80 00              ldy   #cmdlist                 ;restore starting here
3023 EF8E 20 72 E5              jsr   restorezp                ;and restore it
3024 EF91              qtrscheddone                            ; 
3025 EF91 60                    rts                            ;and return
3026 EF92
3027 EF92              qtrroutine                              ; ;gets each node
3028 EF92 38                    sec                            ;for subtract
3029 EF93 A0 0A 00              ldy   #insqtr_count
3030 EF96 B7 8C                 lda   [curr],y                 ;get value
3031 EF98 ED 40 DA              sbc   decval                   ;subtract number of ticks that expired
3032 EF9B 97 8C                 sta   [curr],y                 ;update value
3033 EF9D F0 04                 beq   callit                   ;call the handler
3034 EF9F 90 02                 bcc   callit                   ;if <=0
3035 EFA1              scanmore                                ; 
3036 EFA1 18                    clc                            ;skip to next node
3037 EFA2 60                    rts   
3038 EFA3              callit                                  ; 
3039 EFA3 A0 08 00              ldy   #insqtr_ticks
3040 EFA6 AD 00 DA              lda   tickcount
3041 EFA9 97 8C                 sta   [curr],y                 ;update users tick count field
3042 EFAB A5 8C                 lda   curr                     ;copy to cmdlist for calling
3043 EFAD 85 80                 sta   cmdlist                  ;routine
3044 EFAF A5 8E                 lda   curr+2
3045 EFB1 85 82                 sta   cmdlist+2
3046 EFB3 A0 0C 00              ldy   #insqtr_link
3047 EFB6 20 FB E6              jsr   dodelete                 ;delete before completion
3048 EFB9 20 B8 F9              jsr   forbid                   ;balance permit in retasynflag
3049 EFBC A9 00 00              lda   #noqtrerr                ;call is completing
3050 EFBF 22 47 E9 FD           jsl   retasynflag              ;and call completion if there
3051 EFC3 80 DC                 bra   scanmore                 ;keep scanning
3052 EFC5
3053 EFC5              *
3054 EFC5              * atp.ddpstuff
3055 EFC5              *
3056 EFC5              * these are the interface routines from atp to
3057 EFC5              * dpp.  They will change when the 'real' version
3058 EFC5              * of ddp goes into use.
3059 EFC5              *
3060 EFC5                       EXPORT ddpopenskt 
3061 EFC5              ddpopenskt                              ;
3062 EFC5
3063 EFC5 8E 1D DA              stx   parmlist+5               ;store address of skt listener
3064 EFC8 8C 1F DA              sty   parmlist+7
3065 EFCB E2 30                 sep   #mbit+xbit               ;go to 8 bit x,a
3066 EFCD                       longa off
3067 EFCD                       longi off
3068 EFCD
3069 EFCD 8D 1C DA              sta   parmlist+4               ;socket id
3070 EFD0 A9 0B                 lda   #$0b                     ;command for open ddp socket
3071 EFD2 8D 19 DA              sta   parmlist+1
3072 EFD5 20 DE EF              jsr   makecall                 ;call routine
3073 EFD8                       longa on
3074 EFD8                       longi on
3075 EFD8
3076 EFD8 F0 03                 beq   ok                       ;leave it alone
3077 EFDA A9 0C 05              lda   #noddpskt                ;no ddp socket error
3078 EFDD              ok                                      ; 
3079 EFDD 60                    rts   
3080 EFDE
3081 EFDE                       entry makecall                 ; EXPORT -> ENTRY  **TGH
3082 EFDE              makecall                                ;       ;call with parm list
3083 EFDE C2 30                 rep   #mbit+xbit
3084 EFE0                       longa on
3085 EFE0                       longi on
3086 EFE0
3087 EFE0 A2 18 DA              ldx   #<parmlist
3088 EFE3 A0 E1 00              ldy   #^databank
3089 EFE6 20 73 E4              jsr   atpentry                 ;do the open
3090 EFE9
3091 EFE9 E2 30                 sep   #mbit+xbit               ;make sure in 8 bit x,a
3092 EFEB AE 1C DA              ldx   parmlist+4               ;get socket number assigned
3093 EFEE C2 30                 rep   #mbit+xbit               ;back to full native mode
3094 EFF0 AD 1A DA              lda   parmlist+2               ;z=1 if no error
3095 EFF3 60                    rts                            ;and return
3096 EFF4
3097 EFF4                       EXPORT closeddpskt 
3098 EFF4              closeddpskt                             ;       
3099 EFF4 E2 30                 sep   #mbit+xbit               ;8 bit mode
3100 EFF6                       longa off
3101 EFF6                       longi off
3102 EFF6
3103 EFF6 8D 1C DA              sta   parmlist+4               ;close this socket
3104 EFF9 A9 0C                 lda   #$0c                     ;command for close
3105 EFFB 8D 19 DA              sta   parmlist+1
3106 EFFE 20 DE EF              jsr   makecall                 ;call routine
3107 F001                       longa on
3108 F001                       longi on
3109 F001 F0 03                 beq   okfine                   ;leave it alone
3110 F003 A9 02 05              lda   #atpbadskt               ;no ddp socket error
3111 F006              okfine                                  ; 
3112 F006 60                    rts   
3113 F007
3114 F007
3115 F007              *
3116 F007              * opendriver
3117 F007              * opens the atalk driver for testing
3118 F007              *
3119 F007                       entry opendriver               ; EXPORT -> ENTRY  **TGH
3120 F007              opendriver                              ;
3121 F007
3122 F007                       longa on
3123 F007                       longi on
3124 F007              * assume our reset is always first installed, so it can be
3125 F007              * in rom, since it need not know who it should call
3126 F007 AF 64 F0 FD           lda   >jresetcode              ;$5c+(resetcode<<8)   ;put jml to resetcode
3127 F00B 8F 10 10 E1           sta   softreset                ;routine into the vector
3128 F00F AF 66 F0 FD           lda   >jresetcode+2
3129 F013 8F 12 10 E1           sta   softreset+2
3130 F017
3131 F017
3132 F017              initdriver                              ;       ;only init the driver
3133 F017                       longa on                       ;comes here in full 16
3134 F017                       longi on
3135 F017 C2 30                 rep   #mbit+xbit
3136 F019
3137 F019
3138 F019 08                    php   
3139 F01A 78                    sei                            ;don't want to be interrupted in here
3140 F01B F4 00 00              pea   $0000                    ;push space for result of readtime
3141 F01E F4 00 00              pea   $0000                    ;push space for result of readtime
3142 F021 F4 00 00              pea   $0000                    ;push space for result of readtime
3143 F024 F4 00 00              pea   $0000                    ;push space for result of readtime
3144 F027 A2 03 0D              ldx   #$0d03                   ;call readtimehex
3145 F02A 22 00 00 E1           jsl   >$e10000
3146 F02E 68                    pla                            ;get seconds and minutes
3147 F02F FA                    plx   
3148 F030 FA                    plx   
3149 F031 FA                    plx                            ;discard other stuff
3150 F032 29 FF 00              and   #$00ff                   ;just want number of seconds
3151 F035 8D 6A DE              sta   startcount               ;initialize for 1/4 sec irq routine
3152 F038 28                    plp                            ;restore state
3153 F039
3154 F039 A2 D9 F2              ldx   #iparmstart              ;init parms start
3155 F03C A0 3D DE              ldy   #rparmstart              ;ram parm start
3156 F03F A9 0C 00              lda   #(iend-iparmstart)-1     ;length of initialized data
3157 F042 54 E1 FD              mvn   main,databank            ;from rom to ram
3158 F045
3159 F045
3160 F045 E2 30                 sep   #mbit+xbit
3161 F047                       longa off
3162 F047                       longi off                      ;8 bit x,a
3163 F047
3164 F047 A9 00                 lda   #00                      ;clear them bytes
3165 F049 A0 24                 ldy   #savecnt                 ;number of bytes to clear
3166 F04B              clre1lp                                 ; 
3167 F04B 99 49 DE              sta   initsec-1,y              ;clear bytes in $e1
3168 F04E 88                    dey   
3169 F04F D0 FA                 bne   clre1lp
3170 F051
3171 F051
3172 F051                       longa on
3173 F051                       longi on
3174 F051 C2 31                 rep   #mbit+xbit+cbit
3175 F053 22 C5 F3 FD           jsl   lapinit                  ;through dipatcher. When LAP returns,
3176 F057              *                                       ;A MUST be the result.
3177 F057 AA                    tax                            ;set codes
3178 F058 D0 09                 bne   GetOuttaHere             ;error so exit
3179 F05A EE 68 DE              inc   atalkon                  ;appletalk is on
3180 F05D 20 59 E3              jsr   ddpinit
3181 F060
3182 F060 20 7A EE              jsr   makefreelist             ;create free list of mem
3183 F063
3184 F063
3185 F063              GetOuttaHere                            ; 
3186 F063 6B                    rtl                            ;and return
3187 F064
3188 F064 5C 68 F0 FD  jresetcode jml   resetcode              ;code to call built in dispatch
3189 F068
3190 F068              *
3191 F068              * this is where soft resets come
3192 F068              *
3193 F068
3194 F068              resetcode                               ;       ;this code will be moved to ram
3195 F068 A9 74 DC              lda   #ourstack                ;get base of stack
3196 F06B 8D 04 DA              sta   lsp                      ;and set up stack pointer
3197 F06E 20 4B F5              jsr   lapresetinit             ;let lap zero info before calling it for node init
3198 F071 A2 80 00              ldx   #cmdlist                 ;save zp
3199 F074 A9 28 00              lda   #zplen                   ;length of stuff not saved yet
3200 F077 20 4B E5              jsr   savezp
3201 F07A 9C E1 DD              stz   rinitparms+9             ;change to stz later
3202 F07D A9 D8 DD              lda   #rinitparms              ;do the init with boots list
3203 F080 85 80                 sta   cmdlist
3204 F082 A9 E1 00              lda   #^databank
3205 F085 85 82                 sta   cmdlist+2
3206 F087 22 17 F0 FD           jsl   initdriver               ;init driver stuff and rtl
3207 F08B A0 80 00              ldy   #cmdlist                 ;restore from here
3208 F08E A9 28 00              lda   #zplen                   ;and this much
3209 F091 20 72 E5              jsr   restorezp
3210 F094 6B                    rtl   
3211 F095              rscodelen equ   *-resetcode             ;length of code to relocate
3212 F095
3213 F095
3214 F095
3215 F095                       entry readatpheader            ; EXPORT -> ENTRY  **TGH
3216 F095              readatpheader                           ;	;call ddp to read header
3217 F095                       longa off
3218 F095                       longi off
3219 F095
3220 F095 C2 30                 rep   #mbit+xbit
3221 F097                       longa on
3222 F097                       longi on
3223 F097
3224 F097 A2 3D DE              ldx   #<ratpreadp              ;low byte of header
3225 F09A A0 E1 00              ldy   #^databank               ;high byte of header
3226 F09D 20 73 E4              jsr   atpentry                 ;call dispatcher for read
3227 F0A0 AD 3F DE              lda   ratpreadp+2              ;get result
3228 F0A3 60                    rts                            ;and return
3229 F0A4
3230 F0A4
3231 F0A4              *
3232 F0A4              * readrbds
3233 F0A4              * reads in the data in the packet into our bds structure
3234 F0A4              * y=offset to bds pointer field
3235 F0A4              * a=offset from bds pointer to actual bds entry
3236 F0A4              *
3237 F0A4                       entry readrbds                 ; EXPORT -> ENTRY  **TGH
3238 F0A4              readrbds                                ;
3239 F0A4
3240 F0A4                       longa on
3241 F0A4                       longi on
3242 F0A4 C2 31                 rep   #mbit+xbit+cbit          ;force 16 bit x,a and clear carry
3243 F0A6
3244 F0A6 77 80                 adc   [cmdlist],y              ;add a to low byte of pointer
3245 F0A8 85 A4                 sta   bdsptr
3246 F0AA C8                    iny   
3247 F0AB C8                    iny                            ;go to high word
3248 F0AC A9 00 00              lda   #00
3249 F0AF 77 80                 adc   [cmdlist],y              ;add carry to high word
3250 F0B1 85 A6                 sta   bdsptr+2
3251 F0B3                       entry readrbd2                 ; EXPORT -> ENTRY  **TGH
3252 F0B3              readrbd2                                ;       ;entry point if bdsptr already set
3253 F0B3 C2 30                 rep   #mbit+xbit
3254 F0B5 9C 42 DA              stz   status                   ;assume no error
3255 F0B8 A9 00 08              lda   #$0800                   ;make a readprot call
3256 F0BB 8D 18 DA              sta   parmlist
3257 F0BE 8D 21 DA              sta   parmlist+9               ;use 6 to mean purge in parm list
3258 F0C1 A0 06 00              ldy   #bds_user                ;prepare to move user bytes
3259 F0C4 AD 0E DA              lda   atpheader+4              ;get first 2
3260 F0C7 97 A4                 sta   [bdsptr],y
3261 F0C9 AD 10 DA              lda   atpheader+6              ;pick up last 2
3262 F0CC C8                    iny                            ;move to upper 2 bytes
3263 F0CD C8                    iny   
3264 F0CE 97 A4                 sta   [bdsptr],y               ;done with user bytes
3265 F0D0 A0 02 00              ldy   #bds_bufptr              ;offset to buffer pointer
3266 F0D3 B7 A4                 lda   [bdsptr],y               ;get low word
3267 F0D5 8D 1E DA              sta   parmlist+6               ;save low word
3268 F0D8 C8                    iny                            ;move to high word
3269 F0D9 C8                    iny   
3270 F0DA B7 A4                 lda   [bdsptr],y
3271 F0DC 8D 20 DA              sta   parmlist+8               ;and save it
3272 F0DF A0 00 00              ldy   #bds_bufsize             ;offset to size of buf
3273 F0E2 B7 A4                 lda   [bdsptr],y               ;get maximum amount of data to read
3274 F0E4 8D 1C DA              sta   parmlist+4               ;and save it
3275 F0E7 20 DE EF              jsr   makecall                 ;make call using parmlist
3276 F0EA F0 13                 beq   noerr
3277 F0EC C9 02 02              cmp   #lapendbuf
3278 F0EF F0 0E                 beq   noerr                    ;not an error
3279 F0F1 C9 09 02              cmp   #lapextra                ;special ok type error
3280 F0F4 D0 15                 bne   leave                    ;leave
3281 F0F6 AD 23 DA              lda   parmlist+11
3282 F0F9 09 00 80              ora   #$8000                   ;set error bit
3283 F0FC 8D 23 DA              sta   parmlist+11
3284 F0FF              noerr                                   ; 
3285 F0FF AD 23 DA              lda   parmlist+11
3286 F102 A0 0A 00              ldy   #bds_actlen              ;offset to actual bds len
3287 F105 97 A4                 sta   [bdsptr],y
3288 F107 AD 42 DA              lda   status                   ;return error code
3289 F10A 60                    rts   
3290 F10B              leave                                   ; 
3291 F10B 8D 42 DA              sta   status
3292 F10E 80 EF                 bra   noerr                    ;and leave through there
3293 F110
3294 F110              *
3295 F110              * watppkt
3296 F110              * write atp packet - this routine puts together an atp packet and
3297 F110              * sends it out through ddp.  If it is called with a=$ff then it is
3298 F110              * assumed that the bdsptr has already been calculated, otherwise
3299 F110              * it will calculate it for you based on an offset passed in a
3300 F110              *
3301 F110              * exits in 8 bit mode
3302 F110              *
3303 F110                       entry watppkt                  ; EXPORT -> ENTRY  **TGH
3304 F110              watppkt                                 ;
3305 F110
3306 F110 C2 30                 rep   #mbit+xbit
3307 F112                       longa on
3308 F112                       longi on
3309 F112
3310 F112 AA                    tax                            ;save for compare later
3311 F113 A9 00 0D              lda   #$0d00                   ;do ddp write command
3312 F116 8D 18 DA              sta   parmlist
3313 F119
3314 F119 E2 30                 sep   #mbit+xbit               ;8 bit x,a
3315 F11B                       longa off
3316 F11B                       longi off
3317 F11B
3318 F11B A9 03                 lda   #$03                     ;atp is ddp protocol type 3
3319 F11D 8D 22 DA              sta   parmlist+10
3320 F120 A0 08                 ldy   #atprq_dymskt
3321 F122 B7 80                 lda   [cmdlist],y              ;get socket from atp list
3322 F124 8D 21 DA              sta   parmlist+9               ;save in ddp list
3323 F127 A0 1E                 ldy   #atprq_flag
3324 F129 B7 80                 lda   [cmdlist],y              ;get flag
3325 F12B 29 01                 and   #$01                     ;strip all but checksum bit
3326 F12D 8D 1C DA              sta   parmlist+4
3327 F130
3328 F130 C2 20                 rep   #mbit                    ;16 bit a
3329 F132                       longa on
3330 F132
3331 F132 A0 09                 ldy   #atprq_dnet
3332 F134 B7 80                 lda   [cmdlist],y
3333 F136 8D 1D DA              sta   parmlist+5               ;16 bit store
3334 F139 A0 0B                 ldy   #atprq_dnode             ;destination node & skt
3335 F13B B7 80                 lda   [cmdlist],y
3336 F13D 8D 1F DA              sta   parmlist+7
3337 F140 A9 2C DA              lda   #wdsbase                 ;get base of wds
3338 F143 8D 23 DA              sta   parmlist+11              ;and store it
3339 F146 A9 E1 00              lda   #^databank               ;get high word
3340 F149 8D 25 DA              sta   parmlist+13
3341 F14C
3342 F14C
3343 F14C
3344 F14C              *
3345 F14C              * now the parm list is all set up, so we now set up the wds stuff
3346 F14C              * we should be in 16 bit a mode here
3347 F14C              *
3348 F14C 8A                    txa                            ;save in case we need to use it
3349 F14D E8                    inx                            ;see if they set bds
3350 F14E F0 10                 beq   bdsset                   ;yep so no need
3351 F150 18                    clc                            ;we need to set it up
3352 F151 A0 11                 ldy   #sdrsp_rbdsad            ;offset to bds pointer
3353 F153 77 80                 adc   [cmdlist],y
3354 F155 85 A4                 sta   bdsptr                   ;save low word
3355 F157 A0 13                 ldy   #sdrsp_rbdsad+2
3356 F159 A9 00 00              lda   #00                      ;prepare to add carry
3357 F15C 77 80                 adc   [cmdlist],y
3358 F15E 85 A6                 sta   bdsptr+2
3359 F160              bdsset                                  ; ;bdsptr is now pointing to the bds
3360 F160 A0 0D                 ldy   #atprq_tid
3361 F162 B7 80                 lda   [cmdlist],y              ;get tid
3362 F164 8D 0C DA              sta   atpheader+2
3363 F167 A0 06                 ldy   #bds_user                ;offset to user low word
3364 F169 B7 A4                 lda   [bdsptr],y               ;get it
3365 F16B 8D 0E DA              sta   atpheader+4              ;put in header
3366 F16E C8                    iny   
3367 F16F C8                    iny   
3368 F170 B7 A4                 lda   [bdsptr],y               ;get high user bytes
3369 F172 8D 10 DA              sta   atpheader+6
3370 F175 A9 0A DA              lda   #atpheader               ;only do low word for now
3371 F178 8D 34 DA              sta   wdsbase+8                ;first 4 bytes are reserved
3372 F17B A9 E1 00              lda   #^databank               ;high word
3373 F17E 8D 36 DA              sta   wdsbase+10
3374 F181 A9 08 00              lda   #08
3375 F184 8D 32 DA              sta   wdsbase+6                ;length of above
3376 F187 A0 02                 ldy   #bds_bufptr              ;offset to buffer address
3377 F189 B7 A4                 lda   [bdsptr],y               ;get low word
3378 F18B 8D 3A DA              sta   wdsbase+14               ;and save it (ignore high for now)
3379 F18E C8                    iny   
3380 F18F C8                    iny   
3381 F190 B7 A4                 lda   [bdsptr],y
3382 F192 8D 3C DA              sta   wdsbase+16
3383 F195 A0 00                 ldy   #bds_bufsize             ;move to length field
3384 F197 B7 A4                 lda   [bdsptr],y               ;get it
3385 F199 AE 0A DA              ldx   atpheader                ;get atp type
3386 F19C E0 C0                 cpx   #$c0                     ;see if release
3387 F19E D0 03                 bne   uselen                   ;use len as is
3388 F1A0 A9 00 00              lda   #0000                    ;otherwise use len of 0
3389 F1A3              uselen                                  ; 
3390 F1A3 8D 38 DA              sta   wdsbase+12
3391 F1A6 A9 FF FF              lda   #$ffff                   ;end of list
3392 F1A9 8D 3E DA              sta   wdsbase+18
3393 F1AC              * now the parm list for ddpwrite is completely set up, so off we go
3394 F1AC              * to write the packet
3395 F1AC
3396 F1AC 20 DE EF              jsr   makecall                 ;make call using parmlist
3397 F1AF E2 30                 sep   #mbit+xbit               ;always exit in 8 bit mode from
3398 F1B1
3399 F1B1 60                    rts                            ;and return to our caller
3400 F1B2
3401 F1B2                       entry checkskt                 ; EXPORT -> ENTRY  **TGH
3402 F1B2              checkskt                                ;
3403 F1B2 C2 30                 rep   #mbit+xbit
3404 F1B4                       longa on
3405 F1B4                       longi on
3406 F1B4 20 27 DB              jsr   ddpcheckskt              ;check socket through ddp
3407 F1B7 E0 EB EC              cpx   #<rsplstn                ;see if matches our listener skt
3408 F1BA D0 0A                 bne   skterr                   ;bad socket
3409 F1BC 98                    tya                            ;get high word
3410 F1BD 29 FF 00              and   #$00ff                   ;use only low byte
3411 F1C0 C9 FD 00              cmp   #^rsplstn
3412 F1C3 D0 01                 bne   skterr                   ;got an error
3413 F1C5 60                    rts                            ;all is ok
3414 F1C6              skterr                                  ; 
3415 F1C6 A9 02 05              lda   #atpbadskt               ;return socket error
3416 F1C9 60                    rts   
3417 F1CA
3418 F1CA
3419 F1CA              *
3420 F1CA              * rom based booting
3421 F1CA              *   atp.boot
3422 F1CA              *
3423 F1CA
3424 F1CA
3425 F1CA                       entry bootcode                 ; EXPORT -> ENTRY  **TGH
3426 F1CA              bootcode                                ;
3427 F1CA
3428 F1CA
3429 F1CA                       longa on
3430 F1CA                       longi on
3431 F1CA
3432 F1CA A0 E1 00              ldy   #^databank               ;Init appletalk
3433 F1CD A2 D8 DD              ldx   #rinitparms
3434 F1D0 20 73 E4              jsr   atpentry
3435 F1D3 A2 FF 01              ldx   #$01ff                   ;set stack below where code loads
3436 F1D6 9A                    txs   
3437 F1D7              *
3438 F1D7              * see if we can find somebody to boot from
3439 F1D7              *
3440 F1D7              tryboot                                 ; ;try booting
3441 F1D7 9C 46 DA              stz   cursor                   ;clear cursor position
3442 F1DA
3443 F1DA A0 E1 00              ldy   #^databank
3444 F1DD A2 EE DD              ldx   #rlookparms
3445 F1E0 20 73 E4              jsr   atpentry
3446 F1E3 AD 05 DE              lda   rlookparms+23            ;see if got any
3447 F1E6 29 FF 00              and   #$00ff
3448 F1E9 F0 77                 beq   nocanboot                ;nothing received
3449 F1EB
3450 F1EB E2 30                 sep   #mbit+xbit               ;go to 8 bit
3451 F1ED                       longa off
3452 F1ED                       longi off
3453 F1ED
3454 F1ED A2 27                 ldx   #39                      ;clear line
3455 F1EF A9 A0                 lda   #' '+$80
3456 F1F1              clrlp                                   ; 
3457 F1F1 9F 80 04 00           sta   >sline,x                 ;put on screen
3458 F1F5 CA                    dex   
3459 F1F6 10 F9                 bpl   clrlp
3460 F1F8 A9 AE                 lda   #'.'+$80                 ;reading char
3461 F1FA 8D 48 DA              sta   currpart
3462 F1FD A0 03                 ldy   #03
3463 F1FF              mvlp                                    ; 
3464 F1FF B9 74 DD              lda   lookbuf,y
3465 F202 99 0F DE              sta   rsrqparms+atprq_dnet,y   ;and put in sendrequest list
3466 F205 88                    dey   
3467 F206 10 F7                 bpl   mvlp                     ;and loop till negative
3468 F208
3469 F208 C2 30                 rep   #mbit+xbit
3470 F20A                       longa on
3471 F20A                       longi on
3472 F20A
3473 F20A A9 01 00              lda   #$0001                   ;tell them cortland, and packet 0
3474 F20D 8D 1B DE              sta   rsrqparms+atprq_user
3475 F210 A9 00 08              lda   #code                    ;start code here
3476 F213 8D 31 DE              sta   rsrqbds+bds_bufptr       ;init bds
3477 F216 A9 00 00              lda   #^code
3478 F219 8D 33 DE              sta   rsrqbds+bds_bufptr+2
3479 F21C              getnext                                 ; ;get next buffer
3480 F21C E2 30                 sep   #mbit+xbit
3481 F21E                       longa off
3482 F21E                       longi off
3483 F21E
3484 F21E A9 01                 lda   #01                      ;reset bitmap for next request
3485 F220 8D 27 DE              sta   rsrqparms+atprq_bitmap
3486 F223
3487 F223 C2 30                 rep   #mbit+xbit
3488 F225                       longa on
3489 F225                       longi on
3490 F225
3491 F225 A0 E1 00              ldy   #^databank
3492 F228 A2 06 DE              ldx   #rsrqparms
3493 F22B 20 73 E4              jsr   atpentry                 ;and do it sync
3494 F22E B0 A7                 bcs   tryboot                  ;try again, got an error
3495 F230
3496 F230
3497 F230 E2 30                 sep   #mbit+xbit               ;go to 8 bit x,a
3498 F232                       longa off
3499 F232                       longi off
3500 F232 AD 48 DA              lda   currpart                 ;get char
3501 F235 AE 46 DA              ldx   cursor
3502 F238 E8                    inx                            ;bump cursor
3503 F239 E0 29                 cpx   #41                      ;see if past end of line
3504 F23B 90 07                 bcc   charok                   ;char is in bounds
3505 F23D A2 01                 ldx   #01                      ;back to beginning of line
3506 F23F 49 80                 eor   #$80                     ;flip high bit of char
3507 F241 8D 48 DA              sta   currpart
3508 F244              charok                                  ; 
3509 F244 8E 46 DA              stx   cursor
3510 F247 9F 7F 04 00           sta   >sline-1,x               ;put char on screen
3511 F24B
3512 F24B EE 1C DE              inc   rsrqparms+atprq_user+1   ;ask for next packet
3513 F24E AD 35 DE              lda   rsrqbds+bds_user         ;get eof flag
3514 F251 D0 09                 bne   done                     ;we are done
3515 F253 18                    clc   
3516 F254 EE 32 DE              inc   rsrqbds+bds_bufptr+1     ;increment high byte by 2
3517 F257 EE 32 DE              inc   rsrqbds+bds_bufptr+1     ;and again to give effect of +512
3518 F25A 80 C0                 bra   getnext                  ;get next packet
3519 F25C
3520 F25C              done                                    ;
3521 F25C C2 30                 rep   #mbit+xbit
3522 F25E                       longa on
3523 F25E                       longi on
3524 F25E 5C 00 08 00           jml   code                     ;really jump to code in real version
3525 F262              nocanboot                               ; 
3526 F262 F4 00 00              pea   $0000                    ;switch in bank 0 data
3527 F265 AB                    plb   
3528 F266 AB                    plb   
3529 F267 38                    sec                            ;go to emulation mode
3530 F268 FB                    xce   
3531 F269                       longa off
3532 F269                       longi off
3533 F269 AD 81 C0              lda   romread                  ;switch in the rom
3534 F26C
3535 F26C              ;The following load has been changed from a lda #$c7.  We can't assume
3536 F26C              ;slot 7 anymore.
3537 F26C
3538 F26C AF 45 10 E1           lda   >Cnxx+3                  ;We add 3 to get to the bank byte.
3539 F270 85 01                 sta   $1
3540 F272 5C BA FA 00           jml   $faba
3541 F276
3542 F276                       ENDP 
3543 F276              *
3544 F276              * atp.vars
3545 F276              *
3546 F276
3547 F276              initblock PROC                          ;initialized data
3548 F276
3549 F276                       entry bootstart                ; EXPORT -> ENTRY  **TGH
3550 F276              bootstart                               ; 
3551 F276                       entry initparms                ; EXPORT -> ENTRY  **TGH
3552 F276 00 01 00 00  initparms DC B:$00,$01,$00,$00          ;open the drivers
3553 F27A 80 00 00 00           DC B:$80,$00,$00,$00,$00       ;past junk
3554 F27F 00                    DC B:$00                       ;pick a node, any node
3555 F280 00 00                 DC B:$00,$00
3556 F282
3557 F282                       entry openparms                ; EXPORT -> ENTRY  **TGH
3558 F282 00 14 00 00  openparms DC B:$00,$14,$00,$00,$00      ;open a dynamic socket
3559 F287
3560 F287                       entry closeparms               ; EXPORT -> ENTRY  **TGH
3561 F287 00 15 00 00  closeparms DC B:$00,$15,$00,$00,$00     ;for closing up
3562 F28C
3563 F28C                       entry lookparms                ; EXPORT -> ENTRY  **TGH
3564 F28C 00 10 00 00  lookparms DC B:$00,$10,$00,$00          ;cnt, cmd, result
3565 F290 00 00 00 00           DC B:$00,$00,$00,$00           ;completion routine
3566 F294 29 F3 FD 00           DC L:entityblk                 ;entity name stuff
3567 F298 04                    DC B:4                         ;look every 1 sec
3568 F299 20                    DC B:32                        ;look up to 32 times
3569 F29A 00 00                 DC B:$00,$00                   ;reserved bytes
3570 F29C 64 00                 DC W:100                       ;100 byte buffer
3571 F29E 74 DD                 DC W:lookbuf
3572 F2A0 E1 00                 DC W:$e1
3573 F2A2 01                    DC B:$01                       ;only want 1 match total
3574 F2A3 00                    DC B:$00                       ;number gotten
3575 F2A4
3576 F2A4                       entry srqparms                 ; EXPORT -> ENTRY  **TGH
3577 F2A4 00 12 00 00  srqparms DC B:$00,$12,$00,$00           ;cnt, cmd, result
3578 F2A8 00 00 00 00           DC B:$00,$00,$00,$00           ;io completion
3579 F2AC 00                    DC B:$00                       ;our socket (listener socket)
3580 F2AD 00 00                 DC B:$00,$00                   ;their network
3581 F2AF 00                    DC B:$00                       ;their node
3582 F2B0 00                    DC B:$00                       ;their skt
3583 F2B1 00 00                 DC B:$00,$00                   ;their tid
3584 F2B3 00 00                 DC W:0                         ;buffer to send size
3585 F2B5 00 00 00 00           DC L:0                         ;no buffer used
3586 F2B9 00 00 00 00           DC B:$00,$00,$00,$00           ;user bytes
3587 F2BD 01                    DC B:$01                       ;1 response buffer
3588 F2BE 2F DE                 DC W:rsrqbds                   ;bds for input
3589 F2C0 E1 00                 DC W:$e1
3590 F2C2 00                    DC B:$00                       ;flag
3591 F2C3 04                    DC B:$04                       ;every 1 second
3592 F2C4 40                    DC B:64                        ;try 64 times
3593 F2C5 01                    DC B:$01                       ;bitmap for request
3594 F2C6 00                    DC B:$00
3595 F2C7 00 00 00 00           DC B:$00,$00,$00,$00,$00,$00   ;reserved fields
3596 F2CD
3597 F2CD                       entry srqbds                   ; EXPORT -> ENTRY  **TGH
3598 F2CD 00 02        srqbds   DC W:512                       ;max buf size
3599 F2CF 00 08 00 00           DC L:code                      ;start code here   
3600 F2D3 00 00 00 00           DC B:$00,$00,$00,$00           ;user bytes filled in 
3601 F2D7 00 00                 DC B:$00,$00                   ;and actual length received
3602 F2D9
3603 F2D9                       entry bootend                  ; EXPORT -> ENTRY  **TGH
3604 F2D9              bootend                                 ;           ;end of boot code to be moved
3605 F2D9
3606 F2D9                       entry iparmstart               ; EXPORT -> ENTRY  **TGH
3607 F2D9              iparmstart                              ; 
3608 F2D9              atpreadp                                ; 
3609 F2D9 00                    DC B:00
3610 F2DA 08                    DC B:8
3611 F2DB 00 00                 DC B:$00,$00
3612 F2DD 08 00                 DC W:8
3613 F2DF 0A DA                 DC W:atpheader
3614 F2E1 E1 00                 DC W:$e1
3615 F2E3 00                    DC B:$00                       ;don't purge
3616 F2E4 00 00                 DC B:$00,$00                   ;number of bytes read returned here
3617 F2E6
3618 F2E6                       entry iend                     ; EXPORT -> ENTRY  **TGH
3619 F2E6              iend                                    ; ;end of inited data
3620 F2E6
3621 F2E6
3622 F2E6
3623 F2E6                       ENDP 
3624 F2E6
3625 F2E6
3626 F2E6
3627 F2E6
3628 F2E6
3629 F2E6              romblock PROC                           ;this data is romable
3630 F2E6
3631 F2E6
3632 F2E6                       entry rsptable                 ; EXPORT -> ENTRY  **TGH
3633 F2E6 0D           rsptable DC B:13                        ;ld.dskt
3634 F2E7 00                    DC B:00                        ;ld.snet
3635 F2E8 00                    DC B:00                        ;ld.snet+1
3636 F2E9 0C                    DC B:12                        ;ld.snode
3637 F2EA 0E                    DC B:14                        ;ld.sskt
3638 F2EB 82                    DC B:$82                       ;tidh (atp) switch to atp header
3639 F2EC 03                    DC B:03                        ;tidl (atp)
3640 F2ED FF                    DC B:$ff                       ;end of compare table
3641 F2EE
3642 F2EE                       entry rspcbtable               ; EXPORT -> ENTRY  **TGH
3643 F2EE 0D           rspcbtable DC B:13                      ;ld.dskt
3644 F2EF 09                    DC B:09                        ;ld.snet
3645 F2F0 0A                    DC B:10                        ;ld.snet+1
3646 F2F1 0C                    DC B:12                        ;ld.snode
3647 F2F2 0E                    DC B:14                        ;ld.sskt
3648 F2F3 82                    DC B:$82                       ;tidh (atp) switch to atp header
3649 F2F4 03                    DC B:03                        ;tidl (atp)
3650 F2F5 FF                    DC B:$ff                       ;end of compare table
3651 F2F6
3652 F2F6                       entry grqtable                 ; EXPORT -> ENTRY  **TGH
3653 F2F6 0D           grqtable DC B:13                        ;only verify against ourskt
3654 F2F7 FF                    DC B:$ff                       ;end of table
3655 F2F8
3656 F2F8                       entry canceltable              ; EXPORT -> ENTRY  **TGH
3657 F2F8 00 00 00 00  canceltable DC B:$00,$00,$00,$00,$00    ;skip first 5 items
3658 F2FD 04                    DC B:creq_tid                  ;low byte of tid in list
3659 F2FE 05                    DC B:creq_tid+1                ;high byte of tid in list
3660 F2FF FF                    DC B:$ff                       ;end of list
3661 F300
3662 F300                       entry attachtable              ; EXPORT -> ENTRY  **TGH
3663 F300 08           attachtable DC B:rspcb_sskt             ;table corresponds directly
3664 F301 09                    DC B:rspcb_dnet                ;to the sendresponse packet
3665 F302 0A                    DC B:rspcb_dnet+1              ;so the order of these should
3666 F303 0B                    DC B:rspcb_dnode               ;match the order of sendresponse
3667 F304 0C                    DC B:rspcb_dskt                ;stuff
3668 F305 0D                    DC B:rspcb_tid
3669 F306 0E                    DC B:rspcb_tid+1
3670 F307 FF                    DC B:$ff
3671 F308
3672 F308                       entry addtable                 ; EXPORT -> ENTRY  **TGH
3673 F308 04           addtable DC B:addrsp_sskt
3674 F309 05                    DC B:addrsp_dnet
3675 F30A 06                    DC B:addrsp_dnet+1
3676 F30B 07                    DC B:addrsp_dnode
3677 F30C 08                    DC B:addrsp_dskt
3678 F30D 09                    DC B:addrsp_tid
3679 F30E 0A                    DC B:addrsp_tid+1
3680 F30F FF                    DC B:$ff
3681 F310
3682 F310                       entry reltable                 ; EXPORT -> ENTRY  **TGH
3683 F310 04           reltable DC B:relcb_ourskt
3684 F311 05                    DC B:relcb_snet
3685 F312 06                    DC B:relcb_snet+1
3686 F313 07                    DC B:relcb_snode
3687 F314 08                    DC B:relcb_sskt
3688 F315 09                    DC B:relcb_tid
3689 F316 0A                    DC B:relcb_tid+1
3690 F317 FF                    DC B:$ff
3691 F318
3692 F318                       entry onebitmask               ; EXPORT -> ENTRY  **TGH
3693 F318 01 02 04 08  onebitmask DC B:$01,$02,$04,$08,$10,$20,$40,$80
3694 F320                       entry lowbitmask               ; EXPORT -> ENTRY  **TGH
3695 F320 00 01 03 07  lowbitmask DC B:$00,$01,$03,$07,$0f,$1f,$3f,$7f,$ff
3696 F329
3697 F329                       entry entityblk                ; EXPORT -> ENTRY  **TGH
3698 F329              entityblk                               ; 
3699 F329 01                    DC B:1
3700 F32A 3D                    DC B:'='
3701 F32B 0A                    DC B:tylen                     ;length of type
3702 F32C                       entry tystart                  ; EXPORT -> ENTRY  **TGH
3703 F32C              tystart                                 ; 
3704 F32C 41 70 70 6C           DC B:'Apple //gs'
3705 F336              tylen    equ   *-tystart
3706 F336
3707 F336 01                    DC B:1
3708 F337 2A                    DC B:'*'
3709 F338
3710 F338
3711 F338
3712 F338                       ENDP 
3713 F338
3714 F338              ;xxxxxx	equ	(openparms-initparms)
3715 F338                       END   
3716 F338
3717 F338
